package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class GetTrustStoreRequest(trustStoreArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreRequest = {
    import GetTrustStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreRequest
      .builder()
      .trustStoreArn(ARN.unwrap(trustStoreArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.GetTrustStoreRequest.ReadOnly =
    zio.aws.workspacesweb.model.GetTrustStoreRequest.wrap(buildAwsValue())
}
object GetTrustStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.GetTrustStoreRequest =
      zio.aws.workspacesweb.model.GetTrustStoreRequest(trustStoreArn)
    def trustStoreArn: ARN
    def getTrustStoreArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(trustStoreArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreRequest
  ) extends zio.aws.workspacesweb.model.GetTrustStoreRequest.ReadOnly {
    override val trustStoreArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.trustStoreArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreRequest
  ): zio.aws.workspacesweb.model.GetTrustStoreRequest.ReadOnly = new Wrapper(
    impl
  )
}
