package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class AssociateIpAccessSettingsResponse(
    ipAccessSettingsArn: ARN,
    portalArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.AssociateIpAccessSettingsResponse = {
    import AssociateIpAccessSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.AssociateIpAccessSettingsResponse
      .builder()
      .ipAccessSettingsArn(ARN.unwrap(ipAccessSettingsArn): java.lang.String)
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.AssociateIpAccessSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.AssociateIpAccessSettingsResponse
      .wrap(buildAwsValue())
}
object AssociateIpAccessSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.AssociateIpAccessSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.AssociateIpAccessSettingsResponse =
      zio.aws.workspacesweb.model
        .AssociateIpAccessSettingsResponse(ipAccessSettingsArn, portalArn)
    def ipAccessSettingsArn: ARN
    def portalArn: ARN
    def getIpAccessSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(ipAccessSettingsArn)
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.AssociateIpAccessSettingsResponse
  ) extends zio.aws.workspacesweb.model.AssociateIpAccessSettingsResponse.ReadOnly {
    override val ipAccessSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.ipAccessSettingsArn())
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.AssociateIpAccessSettingsResponse
  ): zio.aws.workspacesweb.model.AssociateIpAccessSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
