package zio.aws.workspacesweb.model
import zio.aws.workspacesweb.model.primitives.{
  IdleDisconnectTimeoutInMinutes,
  DisconnectTimeoutInMinutes,
  ARN
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UserSettings(
    associatedPortalArns: Optional[Iterable[ARN]] = Optional.Absent,
    cookieSynchronizationConfiguration: Optional[
      zio.aws.workspacesweb.model.CookieSynchronizationConfiguration
    ] = Optional.Absent,
    copyAllowed: Optional[zio.aws.workspacesweb.model.EnabledType] =
      Optional.Absent,
    disconnectTimeoutInMinutes: Optional[DisconnectTimeoutInMinutes] =
      Optional.Absent,
    downloadAllowed: Optional[zio.aws.workspacesweb.model.EnabledType] =
      Optional.Absent,
    idleDisconnectTimeoutInMinutes: Optional[IdleDisconnectTimeoutInMinutes] =
      Optional.Absent,
    pasteAllowed: Optional[zio.aws.workspacesweb.model.EnabledType] =
      Optional.Absent,
    printAllowed: Optional[zio.aws.workspacesweb.model.EnabledType] =
      Optional.Absent,
    uploadAllowed: Optional[zio.aws.workspacesweb.model.EnabledType] =
      Optional.Absent,
    userSettingsArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.UserSettings = {
    import UserSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.UserSettings
      .builder()
      .optionallyWith(
        associatedPortalArns.map(value =>
          value.map { item =>
            ARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.associatedPortalArns)
      .optionallyWith(
        cookieSynchronizationConfiguration.map(value => value.buildAwsValue())
      )(_.cookieSynchronizationConfiguration)
      .optionallyWith(copyAllowed.map(value => value.unwrap))(_.copyAllowed)
      .optionallyWith(
        disconnectTimeoutInMinutes.map(value =>
          DisconnectTimeoutInMinutes.unwrap(value): Integer
        )
      )(_.disconnectTimeoutInMinutes)
      .optionallyWith(downloadAllowed.map(value => value.unwrap))(
        _.downloadAllowed
      )
      .optionallyWith(
        idleDisconnectTimeoutInMinutes.map(value =>
          IdleDisconnectTimeoutInMinutes.unwrap(value): Integer
        )
      )(_.idleDisconnectTimeoutInMinutes)
      .optionallyWith(pasteAllowed.map(value => value.unwrap))(_.pasteAllowed)
      .optionallyWith(printAllowed.map(value => value.unwrap))(_.printAllowed)
      .optionallyWith(uploadAllowed.map(value => value.unwrap))(_.uploadAllowed)
      .userSettingsArn(ARN.unwrap(userSettingsArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.UserSettings.ReadOnly =
    zio.aws.workspacesweb.model.UserSettings.wrap(buildAwsValue())
}
object UserSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.UserSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.UserSettings =
      zio.aws.workspacesweb.model.UserSettings(
        associatedPortalArns.map(value => value),
        cookieSynchronizationConfiguration.map(value => value.asEditable),
        copyAllowed.map(value => value),
        disconnectTimeoutInMinutes.map(value => value),
        downloadAllowed.map(value => value),
        idleDisconnectTimeoutInMinutes.map(value => value),
        pasteAllowed.map(value => value),
        printAllowed.map(value => value),
        uploadAllowed.map(value => value),
        userSettingsArn
      )
    def associatedPortalArns: Optional[List[ARN]]
    def cookieSynchronizationConfiguration: Optional[
      zio.aws.workspacesweb.model.CookieSynchronizationConfiguration.ReadOnly
    ]
    def copyAllowed: Optional[zio.aws.workspacesweb.model.EnabledType]
    def disconnectTimeoutInMinutes: Optional[DisconnectTimeoutInMinutes]
    def downloadAllowed: Optional[zio.aws.workspacesweb.model.EnabledType]
    def idleDisconnectTimeoutInMinutes: Optional[IdleDisconnectTimeoutInMinutes]
    def pasteAllowed: Optional[zio.aws.workspacesweb.model.EnabledType]
    def printAllowed: Optional[zio.aws.workspacesweb.model.EnabledType]
    def uploadAllowed: Optional[zio.aws.workspacesweb.model.EnabledType]
    def userSettingsArn: ARN
    def getAssociatedPortalArns: ZIO[Any, AwsError, List[ARN]] =
      AwsError.unwrapOptionField("associatedPortalArns", associatedPortalArns)
    def getCookieSynchronizationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.workspacesweb.model.CookieSynchronizationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cookieSynchronizationConfiguration",
      cookieSynchronizationConfiguration
    )
    def getCopyAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("copyAllowed", copyAllowed)
    def getDisconnectTimeoutInMinutes
        : ZIO[Any, AwsError, DisconnectTimeoutInMinutes] =
      AwsError.unwrapOptionField(
        "disconnectTimeoutInMinutes",
        disconnectTimeoutInMinutes
      )
    def getDownloadAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("downloadAllowed", downloadAllowed)
    def getIdleDisconnectTimeoutInMinutes
        : ZIO[Any, AwsError, IdleDisconnectTimeoutInMinutes] =
      AwsError.unwrapOptionField(
        "idleDisconnectTimeoutInMinutes",
        idleDisconnectTimeoutInMinutes
      )
    def getPasteAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("pasteAllowed", pasteAllowed)
    def getPrintAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("printAllowed", printAllowed)
    def getUploadAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("uploadAllowed", uploadAllowed)
    def getUserSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(userSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.UserSettings
  ) extends zio.aws.workspacesweb.model.UserSettings.ReadOnly {
    override val associatedPortalArns: Optional[List[ARN]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedPortalArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspacesweb.model.primitives.ARN(item)
          }.toList
        )
    override val cookieSynchronizationConfiguration: Optional[
      zio.aws.workspacesweb.model.CookieSynchronizationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cookieSynchronizationConfiguration())
      .map(value =>
        zio.aws.workspacesweb.model.CookieSynchronizationConfiguration
          .wrap(value)
      )
    override val copyAllowed
        : Optional[zio.aws.workspacesweb.model.EnabledType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val disconnectTimeoutInMinutes
        : Optional[DisconnectTimeoutInMinutes] = zio.aws.core.internal
      .optionalFromNullable(impl.disconnectTimeoutInMinutes())
      .map(value =>
        zio.aws.workspacesweb.model.primitives.DisconnectTimeoutInMinutes(value)
      )
    override val downloadAllowed
        : Optional[zio.aws.workspacesweb.model.EnabledType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.downloadAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val idleDisconnectTimeoutInMinutes
        : Optional[IdleDisconnectTimeoutInMinutes] = zio.aws.core.internal
      .optionalFromNullable(impl.idleDisconnectTimeoutInMinutes())
      .map(value =>
        zio.aws.workspacesweb.model.primitives
          .IdleDisconnectTimeoutInMinutes(value)
      )
    override val pasteAllowed
        : Optional[zio.aws.workspacesweb.model.EnabledType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pasteAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val printAllowed
        : Optional[zio.aws.workspacesweb.model.EnabledType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.printAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val uploadAllowed
        : Optional[zio.aws.workspacesweb.model.EnabledType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uploadAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val userSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.userSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.UserSettings
  ): zio.aws.workspacesweb.model.UserSettings.ReadOnly = new Wrapper(impl)
}
