package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetIpAccessSettingsResponse(
    ipAccessSettings: Optional[zio.aws.workspacesweb.model.IpAccessSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.GetIpAccessSettingsResponse = {
    import GetIpAccessSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.GetIpAccessSettingsResponse
      .builder()
      .optionallyWith(ipAccessSettings.map(value => value.buildAwsValue()))(
        _.ipAccessSettings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.GetIpAccessSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.GetIpAccessSettingsResponse
      .wrap(buildAwsValue())
}
object GetIpAccessSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.GetIpAccessSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.GetIpAccessSettingsResponse =
      zio.aws.workspacesweb.model.GetIpAccessSettingsResponse(
        ipAccessSettings.map(value => value.asEditable)
      )
    def ipAccessSettings
        : Optional[zio.aws.workspacesweb.model.IpAccessSettings.ReadOnly]
    def getIpAccessSettings: ZIO[
      Any,
      AwsError,
      zio.aws.workspacesweb.model.IpAccessSettings.ReadOnly
    ] = AwsError.unwrapOptionField("ipAccessSettings", ipAccessSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetIpAccessSettingsResponse
  ) extends zio.aws.workspacesweb.model.GetIpAccessSettingsResponse.ReadOnly {
    override val ipAccessSettings
        : Optional[zio.aws.workspacesweb.model.IpAccessSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAccessSettings())
        .map(value => zio.aws.workspacesweb.model.IpAccessSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetIpAccessSettingsResponse
  ): zio.aws.workspacesweb.model.GetIpAccessSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
