package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListBrowserSettingsResponse(
    browserSettings: Optional[
      Iterable[zio.aws.workspacesweb.model.BrowserSettingsSummary]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse = {
    import ListBrowserSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse
      .builder()
      .optionallyWith(
        browserSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.browserSettings)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.ListBrowserSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.ListBrowserSettingsResponse
      .wrap(buildAwsValue())
}
object ListBrowserSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.ListBrowserSettingsResponse =
      zio.aws.workspacesweb.model.ListBrowserSettingsResponse(
        browserSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def browserSettings: Optional[
      List[zio.aws.workspacesweb.model.BrowserSettingsSummary.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getBrowserSettings: ZIO[Any, AwsError, List[
      zio.aws.workspacesweb.model.BrowserSettingsSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("browserSettings", browserSettings)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse
  ) extends zio.aws.workspacesweb.model.ListBrowserSettingsResponse.ReadOnly {
    override val browserSettings: Optional[
      List[zio.aws.workspacesweb.model.BrowserSettingsSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.browserSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspacesweb.model.BrowserSettingsSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.workspacesweb.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse
  ): zio.aws.workspacesweb.model.ListBrowserSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
