package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class CreateIdentityProviderResponse(identityProviderArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderResponse = {
    import CreateIdentityProviderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderResponse
      .builder()
      .identityProviderArn(ARN.unwrap(identityProviderArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.CreateIdentityProviderResponse.ReadOnly =
    zio.aws.workspacesweb.model.CreateIdentityProviderResponse
      .wrap(buildAwsValue())
}
object CreateIdentityProviderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.CreateIdentityProviderResponse =
      zio.aws.workspacesweb.model
        .CreateIdentityProviderResponse(identityProviderArn)
    def identityProviderArn: ARN
    def getIdentityProviderArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(identityProviderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderResponse
  ) extends zio.aws.workspacesweb.model.CreateIdentityProviderResponse.ReadOnly {
    override val identityProviderArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.identityProviderArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderResponse
  ): zio.aws.workspacesweb.model.CreateIdentityProviderResponse.ReadOnly =
    new Wrapper(impl)
}
