package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.{VpcId, ARN}
import scala.jdk.CollectionConverters._
final case class NetworkSettingsSummary(
    networkSettingsArn: Optional[ARN] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.NetworkSettingsSummary = {
    import NetworkSettingsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.NetworkSettingsSummary
      .builder()
      .optionallyWith(
        networkSettingsArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.networkSettingsArn)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.NetworkSettingsSummary.ReadOnly =
    zio.aws.workspacesweb.model.NetworkSettingsSummary.wrap(buildAwsValue())
}
object NetworkSettingsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.NetworkSettingsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.NetworkSettingsSummary =
      zio.aws.workspacesweb.model.NetworkSettingsSummary(
        networkSettingsArn.map(value => value),
        vpcId.map(value => value)
      )
    def networkSettingsArn: Optional[ARN]
    def vpcId: Optional[VpcId]
    def getNetworkSettingsArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("networkSettingsArn", networkSettingsArn)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.NetworkSettingsSummary
  ) extends zio.aws.workspacesweb.model.NetworkSettingsSummary.ReadOnly {
    override val networkSettingsArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.networkSettingsArn())
      .map(value => zio.aws.workspacesweb.model.primitives.ARN(value))
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.workspacesweb.model.primitives.VpcId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.NetworkSettingsSummary
  ): zio.aws.workspacesweb.model.NetworkSettingsSummary.ReadOnly = new Wrapper(
    impl
  )
}
