package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.{BrowserPolicy, ARN}
import scala.jdk.CollectionConverters._
final case class BrowserSettings(
    associatedPortalArns: Optional[Iterable[ARN]] = Optional.Absent,
    browserPolicy: Optional[BrowserPolicy] = Optional.Absent,
    browserSettingsArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.BrowserSettings = {
    import BrowserSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.BrowserSettings
      .builder()
      .optionallyWith(
        associatedPortalArns.map(value =>
          value.map { item =>
            ARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.associatedPortalArns)
      .optionallyWith(
        browserPolicy.map(value =>
          BrowserPolicy.unwrap(value): java.lang.String
        )
      )(_.browserPolicy)
      .browserSettingsArn(ARN.unwrap(browserSettingsArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.BrowserSettings.ReadOnly =
    zio.aws.workspacesweb.model.BrowserSettings.wrap(buildAwsValue())
}
object BrowserSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.BrowserSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.BrowserSettings =
      zio.aws.workspacesweb.model.BrowserSettings(
        associatedPortalArns.map(value => value),
        browserPolicy.map(value => value),
        browserSettingsArn
      )
    def associatedPortalArns: Optional[List[ARN]]
    def browserPolicy: Optional[BrowserPolicy]
    def browserSettingsArn: ARN
    def getAssociatedPortalArns: ZIO[Any, AwsError, List[ARN]] =
      AwsError.unwrapOptionField("associatedPortalArns", associatedPortalArns)
    def getBrowserPolicy: ZIO[Any, AwsError, BrowserPolicy] =
      AwsError.unwrapOptionField("browserPolicy", browserPolicy)
    def getBrowserSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(browserSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.BrowserSettings
  ) extends zio.aws.workspacesweb.model.BrowserSettings.ReadOnly {
    override val associatedPortalArns: Optional[List[ARN]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedPortalArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspacesweb.model.primitives.ARN(item)
          }.toList
        )
    override val browserPolicy: Optional[BrowserPolicy] = zio.aws.core.internal
      .optionalFromNullable(impl.browserPolicy())
      .map(value => zio.aws.workspacesweb.model.primitives.BrowserPolicy(value))
    override val browserSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.browserSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.BrowserSettings
  ): zio.aws.workspacesweb.model.BrowserSettings.ReadOnly = new Wrapper(impl)
}
