package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class TrustStore(
    associatedPortalArns: Optional[Iterable[ARN]] = Optional.Absent,
    trustStoreArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.TrustStore = {
    import TrustStore.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.TrustStore
      .builder()
      .optionallyWith(
        associatedPortalArns.map(value =>
          value.map { item =>
            ARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.associatedPortalArns)
      .trustStoreArn(ARN.unwrap(trustStoreArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.TrustStore.ReadOnly =
    zio.aws.workspacesweb.model.TrustStore.wrap(buildAwsValue())
}
object TrustStore {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.TrustStore
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.TrustStore =
      zio.aws.workspacesweb.model
        .TrustStore(associatedPortalArns.map(value => value), trustStoreArn)
    def associatedPortalArns: Optional[List[ARN]]
    def trustStoreArn: ARN
    def getAssociatedPortalArns: ZIO[Any, AwsError, List[ARN]] =
      AwsError.unwrapOptionField("associatedPortalArns", associatedPortalArns)
    def getTrustStoreArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(trustStoreArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.TrustStore
  ) extends zio.aws.workspacesweb.model.TrustStore.ReadOnly {
    override val associatedPortalArns: Optional[List[ARN]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedPortalArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspacesweb.model.primitives.ARN(item)
          }.toList
        )
    override val trustStoreArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.trustStoreArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.TrustStore
  ): zio.aws.workspacesweb.model.TrustStore.ReadOnly = new Wrapper(impl)
}
