package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.{
  IdentityProviderName,
  SubresourceARN
}
import scala.jdk.CollectionConverters._
final case class IdentityProviderSummary(
    identityProviderArn: SubresourceARN,
    identityProviderName: Optional[IdentityProviderName] = Optional.Absent,
    identityProviderType: Optional[
      zio.aws.workspacesweb.model.IdentityProviderType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.IdentityProviderSummary = {
    import IdentityProviderSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.IdentityProviderSummary
      .builder()
      .identityProviderArn(
        SubresourceARN.unwrap(identityProviderArn): java.lang.String
      )
      .optionallyWith(
        identityProviderName.map(value =>
          IdentityProviderName.unwrap(value): java.lang.String
        )
      )(_.identityProviderName)
      .optionallyWith(identityProviderType.map(value => value.unwrap))(
        _.identityProviderType
      )
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.IdentityProviderSummary.ReadOnly =
    zio.aws.workspacesweb.model.IdentityProviderSummary.wrap(buildAwsValue())
}
object IdentityProviderSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.IdentityProviderSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.IdentityProviderSummary =
      zio.aws.workspacesweb.model.IdentityProviderSummary(
        identityProviderArn,
        identityProviderName.map(value => value),
        identityProviderType.map(value => value)
      )
    def identityProviderArn: SubresourceARN
    def identityProviderName: Optional[IdentityProviderName]
    def identityProviderType
        : Optional[zio.aws.workspacesweb.model.IdentityProviderType]
    def getIdentityProviderArn: ZIO[Any, Nothing, SubresourceARN] =
      ZIO.succeed(identityProviderArn)
    def getIdentityProviderName: ZIO[Any, AwsError, IdentityProviderName] =
      AwsError.unwrapOptionField("identityProviderName", identityProviderName)
    def getIdentityProviderType
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.IdentityProviderType] =
      AwsError.unwrapOptionField("identityProviderType", identityProviderType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.IdentityProviderSummary
  ) extends zio.aws.workspacesweb.model.IdentityProviderSummary.ReadOnly {
    override val identityProviderArn: SubresourceARN =
      zio.aws.workspacesweb.model.primitives
        .SubresourceARN(impl.identityProviderArn())
    override val identityProviderName: Optional[IdentityProviderName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityProviderName())
        .map(value =>
          zio.aws.workspacesweb.model.primitives.IdentityProviderName(value)
        )
    override val identityProviderType
        : Optional[zio.aws.workspacesweb.model.IdentityProviderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityProviderType())
        .map(value =>
          zio.aws.workspacesweb.model.IdentityProviderType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.IdentityProviderSummary
  ): zio.aws.workspacesweb.model.IdentityProviderSummary.ReadOnly = new Wrapper(
    impl
  )
}
