package zio.aws.workspacesweb.model
import zio.aws.workspacesweb.model.primitives.{
  ARN,
  DisplayName,
  Description,
  Timestamp
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class IpAccessSettingsSummary(
    creationDate: Optional[Timestamp] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    displayName: Optional[DisplayName] = Optional.Absent,
    ipAccessSettingsArn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.IpAccessSettingsSummary = {
    import IpAccessSettingsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.IpAccessSettingsSummary
      .builder()
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        ipAccessSettingsArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.ipAccessSettingsArn)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.IpAccessSettingsSummary.ReadOnly =
    zio.aws.workspacesweb.model.IpAccessSettingsSummary.wrap(buildAwsValue())
}
object IpAccessSettingsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.IpAccessSettingsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.IpAccessSettingsSummary =
      zio.aws.workspacesweb.model.IpAccessSettingsSummary(
        creationDate.map(value => value),
        description.map(value => value),
        displayName.map(value => value),
        ipAccessSettingsArn.map(value => value)
      )
    def creationDate: Optional[Timestamp]
    def description: Optional[Description]
    def displayName: Optional[DisplayName]
    def ipAccessSettingsArn: Optional[ARN]
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getIpAccessSettingsArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("ipAccessSettingsArn", ipAccessSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.IpAccessSettingsSummary
  ) extends zio.aws.workspacesweb.model.IpAccessSettingsSummary.ReadOnly {
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.workspacesweb.model.primitives.Timestamp(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.workspacesweb.model.primitives.Description(value))
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.workspacesweb.model.primitives.DisplayName(value))
    override val ipAccessSettingsArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAccessSettingsArn())
      .map(value => zio.aws.workspacesweb.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.IpAccessSettingsSummary
  ): zio.aws.workspacesweb.model.IpAccessSettingsSummary.ReadOnly = new Wrapper(
    impl
  )
}
