package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class DisassociateNetworkSettingsRequest(portalArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.DisassociateNetworkSettingsRequest = {
    import DisassociateNetworkSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.DisassociateNetworkSettingsRequest
      .builder()
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.DisassociateNetworkSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.DisassociateNetworkSettingsRequest
      .wrap(buildAwsValue())
}
object DisassociateNetworkSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.DisassociateNetworkSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.DisassociateNetworkSettingsRequest =
      zio.aws.workspacesweb.model.DisassociateNetworkSettingsRequest(portalArn)
    def portalArn: ARN
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.DisassociateNetworkSettingsRequest
  ) extends zio.aws.workspacesweb.model.DisassociateNetworkSettingsRequest.ReadOnly {
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.DisassociateNetworkSettingsRequest
  ): zio.aws.workspacesweb.model.DisassociateNetworkSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
