package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class DeleteNetworkSettingsRequest(networkSettingsArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.DeleteNetworkSettingsRequest = {
    import DeleteNetworkSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.DeleteNetworkSettingsRequest
      .builder()
      .networkSettingsArn(ARN.unwrap(networkSettingsArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.DeleteNetworkSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.DeleteNetworkSettingsRequest
      .wrap(buildAwsValue())
}
object DeleteNetworkSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.DeleteNetworkSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.DeleteNetworkSettingsRequest =
      zio.aws.workspacesweb.model
        .DeleteNetworkSettingsRequest(networkSettingsArn)
    def networkSettingsArn: ARN
    def getNetworkSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(networkSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.DeleteNetworkSettingsRequest
  ) extends zio.aws.workspacesweb.model.DeleteNetworkSettingsRequest.ReadOnly {
    override val networkSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.networkSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.DeleteNetworkSettingsRequest
  ): zio.aws.workspacesweb.model.DeleteNetworkSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
