package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class TrustStoreSummary(
    trustStoreArn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.TrustStoreSummary = {
    import TrustStoreSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.TrustStoreSummary
      .builder()
      .optionallyWith(
        trustStoreArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.trustStoreArn)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.TrustStoreSummary.ReadOnly =
    zio.aws.workspacesweb.model.TrustStoreSummary.wrap(buildAwsValue())
}
object TrustStoreSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.TrustStoreSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.TrustStoreSummary =
      zio.aws.workspacesweb.model
        .TrustStoreSummary(trustStoreArn.map(value => value))
    def trustStoreArn: Optional[ARN]
    def getTrustStoreArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("trustStoreArn", trustStoreArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.TrustStoreSummary
  ) extends zio.aws.workspacesweb.model.TrustStoreSummary.ReadOnly {
    override val trustStoreArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.trustStoreArn())
      .map(value => zio.aws.workspacesweb.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.TrustStoreSummary
  ): zio.aws.workspacesweb.model.TrustStoreSummary.ReadOnly = new Wrapper(impl)
}
