package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateBrowserSettingsResponse(
    browserSettings: zio.aws.workspacesweb.model.BrowserSettings
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsResponse = {
    import UpdateBrowserSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsResponse
      .builder()
      .browserSettings(browserSettings.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.UpdateBrowserSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.UpdateBrowserSettingsResponse
      .wrap(buildAwsValue())
}
object UpdateBrowserSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.UpdateBrowserSettingsResponse =
      zio.aws.workspacesweb.model
        .UpdateBrowserSettingsResponse(browserSettings.asEditable)
    def browserSettings: zio.aws.workspacesweb.model.BrowserSettings.ReadOnly
    def getBrowserSettings: ZIO[
      Any,
      Nothing,
      zio.aws.workspacesweb.model.BrowserSettings.ReadOnly
    ] = ZIO.succeed(browserSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsResponse
  ) extends zio.aws.workspacesweb.model.UpdateBrowserSettingsResponse.ReadOnly {
    override val browserSettings
        : zio.aws.workspacesweb.model.BrowserSettings.ReadOnly =
      zio.aws.workspacesweb.model.BrowserSettings.wrap(impl.browserSettings())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsResponse
  ): zio.aws.workspacesweb.model.UpdateBrowserSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
