package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class DisassociateUserSettingsRequest(portalArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.DisassociateUserSettingsRequest = {
    import DisassociateUserSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.DisassociateUserSettingsRequest
      .builder()
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.DisassociateUserSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.DisassociateUserSettingsRequest
      .wrap(buildAwsValue())
}
object DisassociateUserSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.DisassociateUserSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.DisassociateUserSettingsRequest =
      zio.aws.workspacesweb.model.DisassociateUserSettingsRequest(portalArn)
    def portalArn: ARN
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.DisassociateUserSettingsRequest
  ) extends zio.aws.workspacesweb.model.DisassociateUserSettingsRequest.ReadOnly {
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.DisassociateUserSettingsRequest
  ): zio.aws.workspacesweb.model.DisassociateUserSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
