package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListUserAccessLoggingSettingsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    userAccessLoggingSettings: Optional[
      Iterable[zio.aws.workspacesweb.model.UserAccessLoggingSettingsSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsResponse = {
    import ListUserAccessLoggingSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        userAccessLoggingSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userAccessLoggingSettings)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.ListUserAccessLoggingSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.ListUserAccessLoggingSettingsResponse
      .wrap(buildAwsValue())
}
object ListUserAccessLoggingSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.ListUserAccessLoggingSettingsResponse =
      zio.aws.workspacesweb.model.ListUserAccessLoggingSettingsResponse(
        nextToken.map(value => value),
        userAccessLoggingSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def userAccessLoggingSettings: Optional[List[
      zio.aws.workspacesweb.model.UserAccessLoggingSettingsSummary.ReadOnly
    ]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getUserAccessLoggingSettings: ZIO[Any, AwsError, List[
      zio.aws.workspacesweb.model.UserAccessLoggingSettingsSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "userAccessLoggingSettings",
      userAccessLoggingSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsResponse
  ) extends zio.aws.workspacesweb.model.ListUserAccessLoggingSettingsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.workspacesweb.model.primitives.PaginationToken(value)
      )
    override val userAccessLoggingSettings: Optional[List[
      zio.aws.workspacesweb.model.UserAccessLoggingSettingsSummary.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.userAccessLoggingSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspacesweb.model.UserAccessLoggingSettingsSummary
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsResponse
  ): zio.aws.workspacesweb.model.ListUserAccessLoggingSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
