package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class UpdateTrustStoreResponse(trustStoreArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreResponse = {
    import UpdateTrustStoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreResponse
      .builder()
      .trustStoreArn(ARN.unwrap(trustStoreArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.UpdateTrustStoreResponse.ReadOnly =
    zio.aws.workspacesweb.model.UpdateTrustStoreResponse.wrap(buildAwsValue())
}
object UpdateTrustStoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.UpdateTrustStoreResponse =
      zio.aws.workspacesweb.model.UpdateTrustStoreResponse(trustStoreArn)
    def trustStoreArn: ARN
    def getTrustStoreArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(trustStoreArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreResponse
  ) extends zio.aws.workspacesweb.model.UpdateTrustStoreResponse.ReadOnly {
    override val trustStoreArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.trustStoreArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreResponse
  ): zio.aws.workspacesweb.model.UpdateTrustStoreResponse.ReadOnly =
    new Wrapper(impl)
}
