package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class DisassociateTrustStoreRequest(portalArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.DisassociateTrustStoreRequest = {
    import DisassociateTrustStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.DisassociateTrustStoreRequest
      .builder()
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.DisassociateTrustStoreRequest.ReadOnly =
    zio.aws.workspacesweb.model.DisassociateTrustStoreRequest
      .wrap(buildAwsValue())
}
object DisassociateTrustStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.DisassociateTrustStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.DisassociateTrustStoreRequest =
      zio.aws.workspacesweb.model.DisassociateTrustStoreRequest(portalArn)
    def portalArn: ARN
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.DisassociateTrustStoreRequest
  ) extends zio.aws.workspacesweb.model.DisassociateTrustStoreRequest.ReadOnly {
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.DisassociateTrustStoreRequest
  ): zio.aws.workspacesweb.model.DisassociateTrustStoreRequest.ReadOnly =
    new Wrapper(impl)
}
