package zio.aws.workspacesweb.model
import zio.aws.workspacesweb.model.primitives.{
  DisplayName,
  StatusReason,
  Timestamp,
  PortalEndpoint,
  ARN
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Portal(
    browserSettingsArn: Optional[ARN] = Optional.Absent,
    browserType: Optional[zio.aws.workspacesweb.model.BrowserType] =
      Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    displayName: Optional[DisplayName] = Optional.Absent,
    networkSettingsArn: Optional[ARN] = Optional.Absent,
    portalArn: Optional[ARN] = Optional.Absent,
    portalEndpoint: Optional[PortalEndpoint] = Optional.Absent,
    portalStatus: Optional[zio.aws.workspacesweb.model.PortalStatus] =
      Optional.Absent,
    rendererType: Optional[zio.aws.workspacesweb.model.RendererType] =
      Optional.Absent,
    statusReason: Optional[StatusReason] = Optional.Absent,
    trustStoreArn: Optional[ARN] = Optional.Absent,
    userAccessLoggingSettingsArn: Optional[ARN] = Optional.Absent,
    userSettingsArn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.Portal = {
    import Portal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.Portal
      .builder()
      .optionallyWith(
        browserSettingsArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.browserSettingsArn)
      .optionallyWith(browserType.map(value => value.unwrap))(_.browserType)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        networkSettingsArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.networkSettingsArn)
      .optionallyWith(
        portalArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.portalArn)
      .optionallyWith(
        portalEndpoint.map(value =>
          PortalEndpoint.unwrap(value): java.lang.String
        )
      )(_.portalEndpoint)
      .optionallyWith(portalStatus.map(value => value.unwrap))(_.portalStatus)
      .optionallyWith(rendererType.map(value => value.unwrap))(_.rendererType)
      .optionallyWith(
        statusReason.map(value => StatusReason.unwrap(value): java.lang.String)
      )(_.statusReason)
      .optionallyWith(
        trustStoreArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.trustStoreArn)
      .optionallyWith(
        userAccessLoggingSettingsArn.map(value =>
          ARN.unwrap(value): java.lang.String
        )
      )(_.userAccessLoggingSettingsArn)
      .optionallyWith(
        userSettingsArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.userSettingsArn)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.Portal.ReadOnly =
    zio.aws.workspacesweb.model.Portal.wrap(buildAwsValue())
}
object Portal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.Portal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.Portal =
      zio.aws.workspacesweb.model.Portal(
        browserSettingsArn.map(value => value),
        browserType.map(value => value),
        creationDate.map(value => value),
        displayName.map(value => value),
        networkSettingsArn.map(value => value),
        portalArn.map(value => value),
        portalEndpoint.map(value => value),
        portalStatus.map(value => value),
        rendererType.map(value => value),
        statusReason.map(value => value),
        trustStoreArn.map(value => value),
        userAccessLoggingSettingsArn.map(value => value),
        userSettingsArn.map(value => value)
      )
    def browserSettingsArn: Optional[ARN]
    def browserType: Optional[zio.aws.workspacesweb.model.BrowserType]
    def creationDate: Optional[Timestamp]
    def displayName: Optional[DisplayName]
    def networkSettingsArn: Optional[ARN]
    def portalArn: Optional[ARN]
    def portalEndpoint: Optional[PortalEndpoint]
    def portalStatus: Optional[zio.aws.workspacesweb.model.PortalStatus]
    def rendererType: Optional[zio.aws.workspacesweb.model.RendererType]
    def statusReason: Optional[StatusReason]
    def trustStoreArn: Optional[ARN]
    def userAccessLoggingSettingsArn: Optional[ARN]
    def userSettingsArn: Optional[ARN]
    def getBrowserSettingsArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("browserSettingsArn", browserSettingsArn)
    def getBrowserType
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.BrowserType] =
      AwsError.unwrapOptionField("browserType", browserType)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getNetworkSettingsArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("networkSettingsArn", networkSettingsArn)
    def getPortalArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("portalArn", portalArn)
    def getPortalEndpoint: ZIO[Any, AwsError, PortalEndpoint] =
      AwsError.unwrapOptionField("portalEndpoint", portalEndpoint)
    def getPortalStatus
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.PortalStatus] =
      AwsError.unwrapOptionField("portalStatus", portalStatus)
    def getRendererType
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.RendererType] =
      AwsError.unwrapOptionField("rendererType", rendererType)
    def getStatusReason: ZIO[Any, AwsError, StatusReason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getTrustStoreArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("trustStoreArn", trustStoreArn)
    def getUserAccessLoggingSettingsArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField(
        "userAccessLoggingSettingsArn",
        userAccessLoggingSettingsArn
      )
    def getUserSettingsArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("userSettingsArn", userSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.Portal
  ) extends zio.aws.workspacesweb.model.Portal.ReadOnly {
    override val browserSettingsArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.browserSettingsArn())
      .map(value => zio.aws.workspacesweb.model.primitives.ARN(value))
    override val browserType
        : Optional[zio.aws.workspacesweb.model.BrowserType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.browserType())
        .map(value => zio.aws.workspacesweb.model.BrowserType.wrap(value))
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.workspacesweb.model.primitives.Timestamp(value))
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.workspacesweb.model.primitives.DisplayName(value))
    override val networkSettingsArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.networkSettingsArn())
      .map(value => zio.aws.workspacesweb.model.primitives.ARN(value))
    override val portalArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.portalArn())
      .map(value => zio.aws.workspacesweb.model.primitives.ARN(value))
    override val portalEndpoint: Optional[PortalEndpoint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portalEndpoint())
        .map(value =>
          zio.aws.workspacesweb.model.primitives.PortalEndpoint(value)
        )
    override val portalStatus
        : Optional[zio.aws.workspacesweb.model.PortalStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portalStatus())
        .map(value => zio.aws.workspacesweb.model.PortalStatus.wrap(value))
    override val rendererType
        : Optional[zio.aws.workspacesweb.model.RendererType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rendererType())
        .map(value => zio.aws.workspacesweb.model.RendererType.wrap(value))
    override val statusReason: Optional[StatusReason] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => zio.aws.workspacesweb.model.primitives.StatusReason(value))
    override val trustStoreArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.trustStoreArn())
      .map(value => zio.aws.workspacesweb.model.primitives.ARN(value))
    override val userAccessLoggingSettingsArn: Optional[ARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userAccessLoggingSettingsArn())
        .map(value => zio.aws.workspacesweb.model.primitives.ARN(value))
    override val userSettingsArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.userSettingsArn())
      .map(value => zio.aws.workspacesweb.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.Portal
  ): zio.aws.workspacesweb.model.Portal.ReadOnly = new Wrapper(impl)
}
