package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class DeleteTrustStoreRequest(trustStoreArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.DeleteTrustStoreRequest = {
    import DeleteTrustStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.DeleteTrustStoreRequest
      .builder()
      .trustStoreArn(ARN.unwrap(trustStoreArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.DeleteTrustStoreRequest.ReadOnly =
    zio.aws.workspacesweb.model.DeleteTrustStoreRequest.wrap(buildAwsValue())
}
object DeleteTrustStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.DeleteTrustStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.DeleteTrustStoreRequest =
      zio.aws.workspacesweb.model.DeleteTrustStoreRequest(trustStoreArn)
    def trustStoreArn: ARN
    def getTrustStoreArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(trustStoreArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.DeleteTrustStoreRequest
  ) extends zio.aws.workspacesweb.model.DeleteTrustStoreRequest.ReadOnly {
    override val trustStoreArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.trustStoreArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.DeleteTrustStoreRequest
  ): zio.aws.workspacesweb.model.DeleteTrustStoreRequest.ReadOnly = new Wrapper(
    impl
  )
}
