package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class AssociateNetworkSettingsRequest(
    networkSettingsArn: ARN,
    portalArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsRequest = {
    import AssociateNetworkSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsRequest
      .builder()
      .networkSettingsArn(ARN.unwrap(networkSettingsArn): java.lang.String)
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.AssociateNetworkSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.AssociateNetworkSettingsRequest
      .wrap(buildAwsValue())
}
object AssociateNetworkSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.AssociateNetworkSettingsRequest =
      zio.aws.workspacesweb.model
        .AssociateNetworkSettingsRequest(networkSettingsArn, portalArn)
    def networkSettingsArn: ARN
    def portalArn: ARN
    def getNetworkSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(networkSettingsArn)
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsRequest
  ) extends zio.aws.workspacesweb.model.AssociateNetworkSettingsRequest.ReadOnly {
    override val networkSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.networkSettingsArn())
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsRequest
  ): zio.aws.workspacesweb.model.AssociateNetworkSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
