package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetTrustStoreResponse(
    trustStore: Optional[zio.aws.workspacesweb.model.TrustStore] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreResponse = {
    import GetTrustStoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreResponse
      .builder()
      .optionallyWith(trustStore.map(value => value.buildAwsValue()))(
        _.trustStore
      )
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.GetTrustStoreResponse.ReadOnly =
    zio.aws.workspacesweb.model.GetTrustStoreResponse.wrap(buildAwsValue())
}
object GetTrustStoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.GetTrustStoreResponse =
      zio.aws.workspacesweb.model
        .GetTrustStoreResponse(trustStore.map(value => value.asEditable))
    def trustStore: Optional[zio.aws.workspacesweb.model.TrustStore.ReadOnly]
    def getTrustStore
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.TrustStore.ReadOnly] =
      AwsError.unwrapOptionField("trustStore", trustStore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreResponse
  ) extends zio.aws.workspacesweb.model.GetTrustStoreResponse.ReadOnly {
    override val trustStore
        : Optional[zio.aws.workspacesweb.model.TrustStore.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trustStore())
        .map(value => zio.aws.workspacesweb.model.TrustStore.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreResponse
  ): zio.aws.workspacesweb.model.GetTrustStoreResponse.ReadOnly = new Wrapper(
    impl
  )
}
