package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class BrowserSettingsSummary(
    browserSettingsArn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.BrowserSettingsSummary = {
    import BrowserSettingsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.BrowserSettingsSummary
      .builder()
      .optionallyWith(
        browserSettingsArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.browserSettingsArn)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.BrowserSettingsSummary.ReadOnly =
    zio.aws.workspacesweb.model.BrowserSettingsSummary.wrap(buildAwsValue())
}
object BrowserSettingsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.BrowserSettingsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.BrowserSettingsSummary =
      zio.aws.workspacesweb.model
        .BrowserSettingsSummary(browserSettingsArn.map(value => value))
    def browserSettingsArn: Optional[ARN]
    def getBrowserSettingsArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("browserSettingsArn", browserSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.BrowserSettingsSummary
  ) extends zio.aws.workspacesweb.model.BrowserSettingsSummary.ReadOnly {
    override val browserSettingsArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.browserSettingsArn())
      .map(value => zio.aws.workspacesweb.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.BrowserSettingsSummary
  ): zio.aws.workspacesweb.model.BrowserSettingsSummary.ReadOnly = new Wrapper(
    impl
  )
}
