package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.{PortalEndpoint, ARN}
import scala.jdk.CollectionConverters._
final case class CreatePortalResponse(
    portalArn: ARN,
    portalEndpoint: PortalEndpoint
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.CreatePortalResponse = {
    import CreatePortalResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.CreatePortalResponse
      .builder()
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .portalEndpoint(PortalEndpoint.unwrap(portalEndpoint): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.CreatePortalResponse.ReadOnly =
    zio.aws.workspacesweb.model.CreatePortalResponse.wrap(buildAwsValue())
}
object CreatePortalResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.CreatePortalResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.CreatePortalResponse =
      zio.aws.workspacesweb.model
        .CreatePortalResponse(portalArn, portalEndpoint)
    def portalArn: ARN
    def portalEndpoint: PortalEndpoint
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
    def getPortalEndpoint: ZIO[Any, Nothing, PortalEndpoint] =
      ZIO.succeed(portalEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreatePortalResponse
  ) extends zio.aws.workspacesweb.model.CreatePortalResponse.ReadOnly {
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
    override val portalEndpoint: PortalEndpoint =
      zio.aws.workspacesweb.model.primitives
        .PortalEndpoint(impl.portalEndpoint())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreatePortalResponse
  ): zio.aws.workspacesweb.model.CreatePortalResponse.ReadOnly = new Wrapper(
    impl
  )
}
