package zio.aws.workspacesweb.model
import zio.aws.workspacesweb.model.primitives.{ARN, PaginationToken, MaxResults}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListIdentityProvidersRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    portalArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest = {
    import ListIdentityProvidersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.ListIdentityProvidersRequest.ReadOnly =
    zio.aws.workspacesweb.model.ListIdentityProvidersRequest
      .wrap(buildAwsValue())
}
object ListIdentityProvidersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.ListIdentityProvidersRequest =
      zio.aws.workspacesweb.model.ListIdentityProvidersRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        portalArn
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def portalArn: ARN
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest
  ) extends zio.aws.workspacesweb.model.ListIdentityProvidersRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.workspacesweb.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.workspacesweb.model.primitives.PaginationToken(value)
      )
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest
  ): zio.aws.workspacesweb.model.ListIdentityProvidersRequest.ReadOnly =
    new Wrapper(impl)
}
