package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListPortalsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    portals: Optional[Iterable[zio.aws.workspacesweb.model.PortalSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.ListPortalsResponse = {
    import ListPortalsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.ListPortalsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        portals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portals)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.ListPortalsResponse.ReadOnly =
    zio.aws.workspacesweb.model.ListPortalsResponse.wrap(buildAwsValue())
}
object ListPortalsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.ListPortalsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.ListPortalsResponse =
      zio.aws.workspacesweb.model.ListPortalsResponse(
        nextToken.map(value => value),
        portals.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def portals
        : Optional[List[zio.aws.workspacesweb.model.PortalSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPortals: ZIO[Any, AwsError, List[
      zio.aws.workspacesweb.model.PortalSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("portals", portals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListPortalsResponse
  ) extends zio.aws.workspacesweb.model.ListPortalsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.workspacesweb.model.primitives.PaginationToken(value)
      )
    override val portals
        : Optional[List[zio.aws.workspacesweb.model.PortalSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portals())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspacesweb.model.PortalSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListPortalsResponse
  ): zio.aws.workspacesweb.model.ListPortalsResponse.ReadOnly = new Wrapper(
    impl
  )
}
