package zio.aws.workspacesweb
import zio.aws.workspacesweb.model.AssociateNetworkSettingsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.workspacesweb.model.{
  UpdateUserSettingsRequest,
  DeleteUserSettingsRequest,
  ListPortalsRequest,
  DisassociateUserSettingsRequest,
  UpdateNetworkSettingsRequest,
  DeleteBrowserSettingsRequest,
  DeleteTrustStoreRequest,
  ListBrowserSettingsRequest,
  CreateUserSettingsRequest,
  AssociateBrowserSettingsRequest,
  AssociateUserSettingsRequest,
  DeleteNetworkSettingsRequest,
  GetTrustStoreCertificateRequest,
  ListIdentityProvidersRequest,
  CreateIdentityProviderRequest,
  GetBrowserSettingsRequest,
  CreateTrustStoreRequest,
  GetNetworkSettingsRequest,
  ListTagsForResourceRequest,
  GetIdentityProviderRequest,
  GetPortalServiceProviderMetadataRequest,
  CreatePortalRequest,
  UpdateBrowserSettingsRequest,
  ListNetworkSettingsRequest,
  DisassociateNetworkSettingsRequest,
  GetPortalRequest,
  AssociateTrustStoreRequest,
  DeletePortalRequest,
  ListTrustStoreCertificatesRequest,
  GetUserSettingsRequest,
  UpdateIdentityProviderRequest,
  DisassociateBrowserSettingsRequest,
  AssociateNetworkSettingsRequest,
  UpdateTrustStoreRequest,
  DisassociateTrustStoreRequest,
  UntagResourceRequest,
  GetTrustStoreRequest,
  CreateBrowserSettingsRequest,
  CreateNetworkSettingsRequest,
  ListTrustStoresRequest,
  UpdatePortalRequest,
  ListUserSettingsRequest,
  TagResourceRequest,
  DeleteIdentityProviderRequest
}
object WorkSpacesWebMock extends Mock[WorkSpacesWeb] {
  object ListNetworkSettings
      extends Effect[
        ListNetworkSettingsRequest,
        AwsError,
        zio.aws.workspacesweb.model.ListNetworkSettingsResponse.ReadOnly
      ]
  object CreateIdentityProvider
      extends Effect[
        CreateIdentityProviderRequest,
        AwsError,
        zio.aws.workspacesweb.model.CreateIdentityProviderResponse.ReadOnly
      ]
  object CreateBrowserSettings
      extends Effect[
        CreateBrowserSettingsRequest,
        AwsError,
        zio.aws.workspacesweb.model.CreateBrowserSettingsResponse.ReadOnly
      ]
  object CreatePortal
      extends Effect[
        CreatePortalRequest,
        AwsError,
        zio.aws.workspacesweb.model.CreatePortalResponse.ReadOnly
      ]
  object ListPortals
      extends Effect[
        ListPortalsRequest,
        AwsError,
        zio.aws.workspacesweb.model.ListPortalsResponse.ReadOnly
      ]
  object AssociateTrustStore
      extends Effect[
        AssociateTrustStoreRequest,
        AwsError,
        zio.aws.workspacesweb.model.AssociateTrustStoreResponse.ReadOnly
      ]
  object ListTrustStores
      extends Effect[
        ListTrustStoresRequest,
        AwsError,
        zio.aws.workspacesweb.model.ListTrustStoresResponse.ReadOnly
      ]
  object DeletePortal
      extends Effect[
        DeletePortalRequest,
        AwsError,
        zio.aws.workspacesweb.model.DeletePortalResponse.ReadOnly
      ]
  object GetNetworkSettings
      extends Effect[
        GetNetworkSettingsRequest,
        AwsError,
        zio.aws.workspacesweb.model.GetNetworkSettingsResponse.ReadOnly
      ]
  object DisassociateUserSettings
      extends Effect[
        DisassociateUserSettingsRequest,
        AwsError,
        zio.aws.workspacesweb.model.DisassociateUserSettingsResponse.ReadOnly
      ]
  object GetTrustStoreCertificate
      extends Effect[
        GetTrustStoreCertificateRequest,
        AwsError,
        zio.aws.workspacesweb.model.GetTrustStoreCertificateResponse.ReadOnly
      ]
  object CreateTrustStore
      extends Effect[
        CreateTrustStoreRequest,
        AwsError,
        zio.aws.workspacesweb.model.CreateTrustStoreResponse.ReadOnly
      ]
  object GetTrustStore
      extends Effect[
        GetTrustStoreRequest,
        AwsError,
        zio.aws.workspacesweb.model.GetTrustStoreResponse.ReadOnly
      ]
  object DeleteBrowserSettings
      extends Effect[
        DeleteBrowserSettingsRequest,
        AwsError,
        zio.aws.workspacesweb.model.DeleteBrowserSettingsResponse.ReadOnly
      ]
  object CreateNetworkSettings
      extends Effect[
        CreateNetworkSettingsRequest,
        AwsError,
        zio.aws.workspacesweb.model.CreateNetworkSettingsResponse.ReadOnly
      ]
  object DeleteIdentityProvider
      extends Effect[
        DeleteIdentityProviderRequest,
        AwsError,
        zio.aws.workspacesweb.model.DeleteIdentityProviderResponse.ReadOnly
      ]
  object DisassociateTrustStore
      extends Effect[
        DisassociateTrustStoreRequest,
        AwsError,
        zio.aws.workspacesweb.model.DisassociateTrustStoreResponse.ReadOnly
      ]
  object UpdateTrustStore
      extends Effect[
        UpdateTrustStoreRequest,
        AwsError,
        zio.aws.workspacesweb.model.UpdateTrustStoreResponse.ReadOnly
      ]
  object GetPortalServiceProviderMetadata
      extends Effect[
        GetPortalServiceProviderMetadataRequest,
        AwsError,
        zio.aws.workspacesweb.model.GetPortalServiceProviderMetadataResponse.ReadOnly
      ]
  object GetIdentityProvider
      extends Effect[
        GetIdentityProviderRequest,
        AwsError,
        zio.aws.workspacesweb.model.GetIdentityProviderResponse.ReadOnly
      ]
  object ListBrowserSettings
      extends Effect[
        ListBrowserSettingsRequest,
        AwsError,
        zio.aws.workspacesweb.model.ListBrowserSettingsResponse.ReadOnly
      ]
  object UpdateIdentityProvider
      extends Effect[
        UpdateIdentityProviderRequest,
        AwsError,
        zio.aws.workspacesweb.model.UpdateIdentityProviderResponse.ReadOnly
      ]
  object GetUserSettings
      extends Effect[
        GetUserSettingsRequest,
        AwsError,
        zio.aws.workspacesweb.model.GetUserSettingsResponse.ReadOnly
      ]
  object ListTrustStoreCertificates
      extends Effect[
        ListTrustStoreCertificatesRequest,
        AwsError,
        zio.aws.workspacesweb.model.ListTrustStoreCertificatesResponse.ReadOnly
      ]
  object DisassociateNetworkSettings
      extends Effect[
        DisassociateNetworkSettingsRequest,
        AwsError,
        zio.aws.workspacesweb.model.DisassociateNetworkSettingsResponse.ReadOnly
      ]
  object ListIdentityProviders
      extends Effect[
        ListIdentityProvidersRequest,
        AwsError,
        zio.aws.workspacesweb.model.ListIdentityProvidersResponse.ReadOnly
      ]
  object UpdateUserSettings
      extends Effect[
        UpdateUserSettingsRequest,
        AwsError,
        zio.aws.workspacesweb.model.UpdateUserSettingsResponse.ReadOnly
      ]
  object UpdateBrowserSettings
      extends Effect[
        UpdateBrowserSettingsRequest,
        AwsError,
        zio.aws.workspacesweb.model.UpdateBrowserSettingsResponse.ReadOnly
      ]
  object ListUserSettings
      extends Effect[
        ListUserSettingsRequest,
        AwsError,
        zio.aws.workspacesweb.model.ListUserSettingsResponse.ReadOnly
      ]
  object AssociateNetworkSettings
      extends Effect[AssociateNetworkSettingsRequest, AwsError, ReadOnly]
  object CreateUserSettings
      extends Effect[
        CreateUserSettingsRequest,
        AwsError,
        zio.aws.workspacesweb.model.CreateUserSettingsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.workspacesweb.model.UntagResourceResponse.ReadOnly
      ]
  object AssociateBrowserSettings
      extends Effect[
        AssociateBrowserSettingsRequest,
        AwsError,
        zio.aws.workspacesweb.model.AssociateBrowserSettingsResponse.ReadOnly
      ]
  object DeleteTrustStore
      extends Effect[
        DeleteTrustStoreRequest,
        AwsError,
        zio.aws.workspacesweb.model.DeleteTrustStoreResponse.ReadOnly
      ]
  object DeleteUserSettings
      extends Effect[
        DeleteUserSettingsRequest,
        AwsError,
        zio.aws.workspacesweb.model.DeleteUserSettingsResponse.ReadOnly
      ]
  object UpdatePortal
      extends Effect[
        UpdatePortalRequest,
        AwsError,
        zio.aws.workspacesweb.model.UpdatePortalResponse.ReadOnly
      ]
  object DeleteNetworkSettings
      extends Effect[
        DeleteNetworkSettingsRequest,
        AwsError,
        zio.aws.workspacesweb.model.DeleteNetworkSettingsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.workspacesweb.model.ListTagsForResourceResponse.ReadOnly
      ]
  object GetPortal
      extends Effect[
        GetPortalRequest,
        AwsError,
        zio.aws.workspacesweb.model.GetPortalResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.workspacesweb.model.TagResourceResponse.ReadOnly
      ]
  object DisassociateBrowserSettings
      extends Effect[
        DisassociateBrowserSettingsRequest,
        AwsError,
        zio.aws.workspacesweb.model.DisassociateBrowserSettingsResponse.ReadOnly
      ]
  object UpdateNetworkSettings
      extends Effect[
        UpdateNetworkSettingsRequest,
        AwsError,
        zio.aws.workspacesweb.model.UpdateNetworkSettingsResponse.ReadOnly
      ]
  object GetBrowserSettings
      extends Effect[
        GetBrowserSettingsRequest,
        AwsError,
        zio.aws.workspacesweb.model.GetBrowserSettingsResponse.ReadOnly
      ]
  object AssociateUserSettings
      extends Effect[
        AssociateUserSettingsRequest,
        AwsError,
        zio.aws.workspacesweb.model.AssociateUserSettingsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, WorkSpacesWeb] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new WorkSpacesWeb {
          val api: WorkSpacesWebAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : WorkSpacesWeb = this
          def listNetworkSettings(request: ListNetworkSettingsRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.ListNetworkSettingsResponse.ReadOnly
          ] = proxy(ListNetworkSettings, request)
          def createIdentityProvider(
              request: CreateIdentityProviderRequest
          ): IO[
            AwsError,
            zio.aws.workspacesweb.model.CreateIdentityProviderResponse.ReadOnly
          ] = proxy(CreateIdentityProvider, request)
          def createBrowserSettings(request: CreateBrowserSettingsRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.CreateBrowserSettingsResponse.ReadOnly
          ] = proxy(CreateBrowserSettings, request)
          def createPortal(request: CreatePortalRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.CreatePortalResponse.ReadOnly
          ] = proxy(CreatePortal, request)
          def listPortals(request: ListPortalsRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.ListPortalsResponse.ReadOnly
          ] = proxy(ListPortals, request)
          def associateTrustStore(request: AssociateTrustStoreRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.AssociateTrustStoreResponse.ReadOnly
          ] = proxy(AssociateTrustStore, request)
          def listTrustStores(request: ListTrustStoresRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.ListTrustStoresResponse.ReadOnly
          ] = proxy(ListTrustStores, request)
          def deletePortal(request: DeletePortalRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.DeletePortalResponse.ReadOnly
          ] = proxy(DeletePortal, request)
          def getNetworkSettings(request: GetNetworkSettingsRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.GetNetworkSettingsResponse.ReadOnly
          ] = proxy(GetNetworkSettings, request)
          def disassociateUserSettings(
              request: DisassociateUserSettingsRequest
          ): IO[
            AwsError,
            zio.aws.workspacesweb.model.DisassociateUserSettingsResponse.ReadOnly
          ] = proxy(DisassociateUserSettings, request)
          def getTrustStoreCertificate(
              request: GetTrustStoreCertificateRequest
          ): IO[
            AwsError,
            zio.aws.workspacesweb.model.GetTrustStoreCertificateResponse.ReadOnly
          ] = proxy(GetTrustStoreCertificate, request)
          def createTrustStore(request: CreateTrustStoreRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.CreateTrustStoreResponse.ReadOnly
          ] = proxy(CreateTrustStore, request)
          def getTrustStore(request: GetTrustStoreRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.GetTrustStoreResponse.ReadOnly
          ] = proxy(GetTrustStore, request)
          def deleteBrowserSettings(request: DeleteBrowserSettingsRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.DeleteBrowserSettingsResponse.ReadOnly
          ] = proxy(DeleteBrowserSettings, request)
          def createNetworkSettings(request: CreateNetworkSettingsRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.CreateNetworkSettingsResponse.ReadOnly
          ] = proxy(CreateNetworkSettings, request)
          def deleteIdentityProvider(
              request: DeleteIdentityProviderRequest
          ): IO[
            AwsError,
            zio.aws.workspacesweb.model.DeleteIdentityProviderResponse.ReadOnly
          ] = proxy(DeleteIdentityProvider, request)
          def disassociateTrustStore(
              request: DisassociateTrustStoreRequest
          ): IO[
            AwsError,
            zio.aws.workspacesweb.model.DisassociateTrustStoreResponse.ReadOnly
          ] = proxy(DisassociateTrustStore, request)
          def updateTrustStore(request: UpdateTrustStoreRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.UpdateTrustStoreResponse.ReadOnly
          ] = proxy(UpdateTrustStore, request)
          def getPortalServiceProviderMetadata(
              request: GetPortalServiceProviderMetadataRequest
          ): IO[
            AwsError,
            zio.aws.workspacesweb.model.GetPortalServiceProviderMetadataResponse.ReadOnly
          ] = proxy(GetPortalServiceProviderMetadata, request)
          def getIdentityProvider(request: GetIdentityProviderRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.GetIdentityProviderResponse.ReadOnly
          ] = proxy(GetIdentityProvider, request)
          def listBrowserSettings(request: ListBrowserSettingsRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.ListBrowserSettingsResponse.ReadOnly
          ] = proxy(ListBrowserSettings, request)
          def updateIdentityProvider(
              request: UpdateIdentityProviderRequest
          ): IO[
            AwsError,
            zio.aws.workspacesweb.model.UpdateIdentityProviderResponse.ReadOnly
          ] = proxy(UpdateIdentityProvider, request)
          def getUserSettings(request: GetUserSettingsRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.GetUserSettingsResponse.ReadOnly
          ] = proxy(GetUserSettings, request)
          def listTrustStoreCertificates(
              request: ListTrustStoreCertificatesRequest
          ): IO[
            AwsError,
            zio.aws.workspacesweb.model.ListTrustStoreCertificatesResponse.ReadOnly
          ] = proxy(ListTrustStoreCertificates, request)
          def disassociateNetworkSettings(
              request: DisassociateNetworkSettingsRequest
          ): IO[
            AwsError,
            zio.aws.workspacesweb.model.DisassociateNetworkSettingsResponse.ReadOnly
          ] = proxy(DisassociateNetworkSettings, request)
          def listIdentityProviders(request: ListIdentityProvidersRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.ListIdentityProvidersResponse.ReadOnly
          ] = proxy(ListIdentityProviders, request)
          def updateUserSettings(request: UpdateUserSettingsRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.UpdateUserSettingsResponse.ReadOnly
          ] = proxy(UpdateUserSettings, request)
          def updateBrowserSettings(request: UpdateBrowserSettingsRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.UpdateBrowserSettingsResponse.ReadOnly
          ] = proxy(UpdateBrowserSettings, request)
          def listUserSettings(request: ListUserSettingsRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.ListUserSettingsResponse.ReadOnly
          ] = proxy(ListUserSettings, request)
          def associateNetworkSettings(
              request: AssociateNetworkSettingsRequest
          ): IO[AwsError, ReadOnly] = proxy(AssociateNetworkSettings, request)
          def createUserSettings(request: CreateUserSettingsRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.CreateUserSettingsResponse.ReadOnly
          ] = proxy(CreateUserSettings, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def associateBrowserSettings(
              request: AssociateBrowserSettingsRequest
          ): IO[
            AwsError,
            zio.aws.workspacesweb.model.AssociateBrowserSettingsResponse.ReadOnly
          ] = proxy(AssociateBrowserSettings, request)
          def deleteTrustStore(request: DeleteTrustStoreRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.DeleteTrustStoreResponse.ReadOnly
          ] = proxy(DeleteTrustStore, request)
          def deleteUserSettings(request: DeleteUserSettingsRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.DeleteUserSettingsResponse.ReadOnly
          ] = proxy(DeleteUserSettings, request)
          def updatePortal(request: UpdatePortalRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.UpdatePortalResponse.ReadOnly
          ] = proxy(UpdatePortal, request)
          def deleteNetworkSettings(request: DeleteNetworkSettingsRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.DeleteNetworkSettingsResponse.ReadOnly
          ] = proxy(DeleteNetworkSettings, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def getPortal(request: GetPortalRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.GetPortalResponse.ReadOnly
          ] = proxy(GetPortal, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def disassociateBrowserSettings(
              request: DisassociateBrowserSettingsRequest
          ): IO[
            AwsError,
            zio.aws.workspacesweb.model.DisassociateBrowserSettingsResponse.ReadOnly
          ] = proxy(DisassociateBrowserSettings, request)
          def updateNetworkSettings(request: UpdateNetworkSettingsRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.UpdateNetworkSettingsResponse.ReadOnly
          ] = proxy(UpdateNetworkSettings, request)
          def getBrowserSettings(request: GetBrowserSettingsRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.GetBrowserSettingsResponse.ReadOnly
          ] = proxy(GetBrowserSettings, request)
          def associateUserSettings(request: AssociateUserSettingsRequest): IO[
            AwsError,
            zio.aws.workspacesweb.model.AssociateUserSettingsResponse.ReadOnly
          ] = proxy(AssociateUserSettings, request)
        }
      }
    }
  }
}
