package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class GetTrustStoreCertificateResponse(
    certificate: Optional[zio.aws.workspacesweb.model.Certificate] =
      Optional.Absent,
    trustStoreArn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateResponse = {
    import GetTrustStoreCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateResponse
      .builder()
      .optionallyWith(certificate.map(value => value.buildAwsValue()))(
        _.certificate
      )
      .optionallyWith(
        trustStoreArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.trustStoreArn)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.GetTrustStoreCertificateResponse.ReadOnly =
    zio.aws.workspacesweb.model.GetTrustStoreCertificateResponse
      .wrap(buildAwsValue())
}
object GetTrustStoreCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.GetTrustStoreCertificateResponse =
      zio.aws.workspacesweb.model.GetTrustStoreCertificateResponse(
        certificate.map(value => value.asEditable),
        trustStoreArn.map(value => value)
      )
    def certificate: Optional[zio.aws.workspacesweb.model.Certificate.ReadOnly]
    def trustStoreArn: Optional[ARN]
    def getCertificate
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.Certificate.ReadOnly] =
      AwsError.unwrapOptionField("certificate", certificate)
    def getTrustStoreArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("trustStoreArn", trustStoreArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateResponse
  ) extends zio.aws.workspacesweb.model.GetTrustStoreCertificateResponse.ReadOnly {
    override val certificate
        : Optional[zio.aws.workspacesweb.model.Certificate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificate())
        .map(value => zio.aws.workspacesweb.model.Certificate.wrap(value))
    override val trustStoreArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.trustStoreArn())
      .map(value => zio.aws.workspacesweb.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateResponse
  ): zio.aws.workspacesweb.model.GetTrustStoreCertificateResponse.ReadOnly =
    new Wrapper(impl)
}
