package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workspacesweb.model.primitives.{
  IdentityProviderName,
  StringType,
  ARN,
  ClientToken
}
import scala.jdk.CollectionConverters._
final case class UpdateIdentityProviderRequest(
    clientToken: Option[ClientToken] = None,
    identityProviderArn: ARN,
    identityProviderDetails: Option[Map[StringType, StringType]] = None,
    identityProviderName: Option[IdentityProviderName] = None,
    identityProviderType: Option[
      zio.aws.workspacesweb.model.IdentityProviderType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.UpdateIdentityProviderRequest = {
    import UpdateIdentityProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.UpdateIdentityProviderRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .identityProviderArn(ARN.unwrap(identityProviderArn): java.lang.String)
      .optionallyWith(
        identityProviderDetails.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.identityProviderDetails)
      .optionallyWith(
        identityProviderName.map(value =>
          IdentityProviderName.unwrap(value): java.lang.String
        )
      )(_.identityProviderName)
      .optionallyWith(identityProviderType.map(value => value.unwrap))(
        _.identityProviderType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.UpdateIdentityProviderRequest.ReadOnly =
    zio.aws.workspacesweb.model.UpdateIdentityProviderRequest
      .wrap(buildAwsValue())
}
object UpdateIdentityProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.UpdateIdentityProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.UpdateIdentityProviderRequest =
      zio.aws.workspacesweb.model.UpdateIdentityProviderRequest(
        clientToken.map(value => value),
        identityProviderArn,
        identityProviderDetails.map(value => value),
        identityProviderName.map(value => value),
        identityProviderType.map(value => value)
      )
    def clientToken: Option[ClientToken]
    def identityProviderArn: ARN
    def identityProviderDetails: Option[Map[StringType, StringType]]
    def identityProviderName: Option[IdentityProviderName]
    def identityProviderType
        : Option[zio.aws.workspacesweb.model.IdentityProviderType]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getIdentityProviderArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(identityProviderArn)
    def getIdentityProviderDetails
        : ZIO[Any, AwsError, Map[StringType, StringType]] = AwsError
      .unwrapOptionField("identityProviderDetails", identityProviderDetails)
    def getIdentityProviderName: ZIO[Any, AwsError, IdentityProviderName] =
      AwsError.unwrapOptionField("identityProviderName", identityProviderName)
    def getIdentityProviderType
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.IdentityProviderType] =
      AwsError.unwrapOptionField("identityProviderType", identityProviderType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateIdentityProviderRequest
  ) extends zio.aws.workspacesweb.model.UpdateIdentityProviderRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.workspacesweb.model.primitives.ClientToken(value))
    override val identityProviderArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.identityProviderArn())
    override val identityProviderDetails: Option[Map[StringType, StringType]] =
      scala
        .Option(impl.identityProviderDetails())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: StringType) -> (value: StringType)
            })
            .toMap
        )
    override val identityProviderName: Option[IdentityProviderName] = scala
      .Option(impl.identityProviderName())
      .map(value =>
        zio.aws.workspacesweb.model.primitives.IdentityProviderName(value)
      )
    override val identityProviderType
        : Option[zio.aws.workspacesweb.model.IdentityProviderType] = scala
      .Option(impl.identityProviderType())
      .map(value =>
        zio.aws.workspacesweb.model.IdentityProviderType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateIdentityProviderRequest
  ): zio.aws.workspacesweb.model.UpdateIdentityProviderRequest.ReadOnly =
    new Wrapper(impl)
}
