package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workspacesweb.model.primitives.{ARN, ClientToken}
import scala.jdk.CollectionConverters._
final case class UpdateUserSettingsRequest(
    clientToken: Option[ClientToken] = None,
    copyAllowed: Option[zio.aws.workspacesweb.model.EnabledType] = None,
    downloadAllowed: Option[zio.aws.workspacesweb.model.EnabledType] = None,
    pasteAllowed: Option[zio.aws.workspacesweb.model.EnabledType] = None,
    printAllowed: Option[zio.aws.workspacesweb.model.EnabledType] = None,
    uploadAllowed: Option[zio.aws.workspacesweb.model.EnabledType] = None,
    userSettingsArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsRequest = {
    import UpdateUserSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(copyAllowed.map(value => value.unwrap))(_.copyAllowed)
      .optionallyWith(downloadAllowed.map(value => value.unwrap))(
        _.downloadAllowed
      )
      .optionallyWith(pasteAllowed.map(value => value.unwrap))(_.pasteAllowed)
      .optionallyWith(printAllowed.map(value => value.unwrap))(_.printAllowed)
      .optionallyWith(uploadAllowed.map(value => value.unwrap))(_.uploadAllowed)
      .userSettingsArn(ARN.unwrap(userSettingsArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.UpdateUserSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.UpdateUserSettingsRequest.wrap(buildAwsValue())
}
object UpdateUserSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.UpdateUserSettingsRequest =
      zio.aws.workspacesweb.model.UpdateUserSettingsRequest(
        clientToken.map(value => value),
        copyAllowed.map(value => value),
        downloadAllowed.map(value => value),
        pasteAllowed.map(value => value),
        printAllowed.map(value => value),
        uploadAllowed.map(value => value),
        userSettingsArn
      )
    def clientToken: Option[ClientToken]
    def copyAllowed: Option[zio.aws.workspacesweb.model.EnabledType]
    def downloadAllowed: Option[zio.aws.workspacesweb.model.EnabledType]
    def pasteAllowed: Option[zio.aws.workspacesweb.model.EnabledType]
    def printAllowed: Option[zio.aws.workspacesweb.model.EnabledType]
    def uploadAllowed: Option[zio.aws.workspacesweb.model.EnabledType]
    def userSettingsArn: ARN
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCopyAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("copyAllowed", copyAllowed)
    def getDownloadAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("downloadAllowed", downloadAllowed)
    def getPasteAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("pasteAllowed", pasteAllowed)
    def getPrintAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("printAllowed", printAllowed)
    def getUploadAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("uploadAllowed", uploadAllowed)
    def getUserSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(userSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsRequest
  ) extends zio.aws.workspacesweb.model.UpdateUserSettingsRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.workspacesweb.model.primitives.ClientToken(value))
    override val copyAllowed: Option[zio.aws.workspacesweb.model.EnabledType] =
      scala
        .Option(impl.copyAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val downloadAllowed
        : Option[zio.aws.workspacesweb.model.EnabledType] = scala
      .Option(impl.downloadAllowed())
      .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val pasteAllowed: Option[zio.aws.workspacesweb.model.EnabledType] =
      scala
        .Option(impl.pasteAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val printAllowed: Option[zio.aws.workspacesweb.model.EnabledType] =
      scala
        .Option(impl.printAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val uploadAllowed
        : Option[zio.aws.workspacesweb.model.EnabledType] = scala
      .Option(impl.uploadAllowed())
      .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val userSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.userSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsRequest
  ): zio.aws.workspacesweb.model.UpdateUserSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
