package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workspacesweb.model.primitives.{
  VpcId,
  SubnetId,
  SecurityGroupId,
  ClientToken
}
import scala.jdk.CollectionConverters._
final case class CreateNetworkSettingsRequest(
    clientToken: Option[ClientToken] = None,
    securityGroupIds: Iterable[SecurityGroupId],
    subnetIds: Iterable[SubnetId],
    tags: Option[Iterable[zio.aws.workspacesweb.model.Tag]] = None,
    vpcId: VpcId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsRequest = {
    import CreateNetworkSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .securityGroupIds(securityGroupIds.map { item =>
        SecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.CreateNetworkSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.CreateNetworkSettingsRequest
      .wrap(buildAwsValue())
}
object CreateNetworkSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.CreateNetworkSettingsRequest =
      zio.aws.workspacesweb.model.CreateNetworkSettingsRequest(
        clientToken.map(value => value),
        securityGroupIds,
        subnetIds,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcId
      )
    def clientToken: Option[ClientToken]
    def securityGroupIds: List[SecurityGroupId]
    def subnetIds: List[SubnetId]
    def tags: Option[List[zio.aws.workspacesweb.model.Tag.ReadOnly]]
    def vpcId: VpcId
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getSecurityGroupIds: ZIO[Any, Nothing, List[SecurityGroupId]] =
      ZIO.succeed(securityGroupIds)
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.workspacesweb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsRequest
  ) extends zio.aws.workspacesweb.model.CreateNetworkSettingsRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.workspacesweb.model.primitives.ClientToken(value))
    override val securityGroupIds: List[SecurityGroupId] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.workspacesweb.model.primitives.SecurityGroupId(item)
      }
      .toList
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.workspacesweb.model.primitives.SubnetId(item)
      }
      .toList
    override val tags: Option[List[zio.aws.workspacesweb.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspacesweb.model.Tag.wrap(item)
          }.toList
        )
    override val vpcId: VpcId =
      zio.aws.workspacesweb.model.primitives.VpcId(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsRequest
  ): zio.aws.workspacesweb.model.CreateNetworkSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
