package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class TrustStore(
    associatedPortalArns: Option[Iterable[ARN]] = None,
    trustStoreArn: Option[ARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.TrustStore = {
    import TrustStore.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.TrustStore
      .builder()
      .optionallyWith(
        associatedPortalArns.map(value =>
          value.map { item =>
            ARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.associatedPortalArns)
      .optionallyWith(
        trustStoreArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.trustStoreArn)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.TrustStore.ReadOnly =
    zio.aws.workspacesweb.model.TrustStore.wrap(buildAwsValue())
}
object TrustStore {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.TrustStore
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.TrustStore =
      zio.aws.workspacesweb.model.TrustStore(
        associatedPortalArns.map(value => value),
        trustStoreArn.map(value => value)
      )
    def associatedPortalArns: Option[List[ARN]]
    def trustStoreArn: Option[ARN]
    def getAssociatedPortalArns: ZIO[Any, AwsError, List[ARN]] =
      AwsError.unwrapOptionField("associatedPortalArns", associatedPortalArns)
    def getTrustStoreArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("trustStoreArn", trustStoreArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.TrustStore
  ) extends zio.aws.workspacesweb.model.TrustStore.ReadOnly {
    override val associatedPortalArns: Option[List[ARN]] = scala
      .Option(impl.associatedPortalArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspacesweb.model.primitives.ARN(item)
        }.toList
      )
    override val trustStoreArn: Option[ARN] = scala
      .Option(impl.trustStoreArn())
      .map(value => zio.aws.workspacesweb.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.TrustStore
  ): zio.aws.workspacesweb.model.TrustStore.ReadOnly = new Wrapper(impl)
}
