package zio.aws.workspacesweb
import zio.aws.workspacesweb.model.AssociateNetworkSettingsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.workspacesweb.{
  WorkSpacesWebAsyncClientBuilder,
  WorkSpacesWebAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.aws.workspacesweb.model.{
  UpdateUserSettingsRequest,
  DeleteUserSettingsRequest,
  ListPortalsRequest,
  DisassociateUserSettingsRequest,
  UpdateNetworkSettingsRequest,
  DeleteBrowserSettingsRequest,
  DeleteTrustStoreRequest,
  ListBrowserSettingsRequest,
  CreateUserSettingsRequest,
  AssociateBrowserSettingsRequest,
  AssociateUserSettingsRequest,
  DeleteNetworkSettingsRequest,
  GetTrustStoreCertificateRequest,
  ListIdentityProvidersRequest,
  CreateIdentityProviderRequest,
  GetBrowserSettingsRequest,
  CreateTrustStoreRequest,
  GetNetworkSettingsRequest,
  ListTagsForResourceRequest,
  GetIdentityProviderRequest,
  GetPortalServiceProviderMetadataRequest,
  CreatePortalRequest,
  UpdateBrowserSettingsRequest,
  ListNetworkSettingsRequest,
  DisassociateNetworkSettingsRequest,
  GetPortalRequest,
  AssociateTrustStoreRequest,
  DeletePortalRequest,
  ListTrustStoreCertificatesRequest,
  GetUserSettingsRequest,
  UpdateIdentityProviderRequest,
  DisassociateBrowserSettingsRequest,
  AssociateNetworkSettingsRequest,
  UpdateTrustStoreRequest,
  DisassociateTrustStoreRequest,
  UntagResourceRequest,
  GetTrustStoreRequest,
  CreateBrowserSettingsRequest,
  CreateNetworkSettingsRequest,
  ListTrustStoresRequest,
  UpdatePortalRequest,
  ListUserSettingsRequest,
  TagResourceRequest,
  DeleteIdentityProviderRequest
}
import software.amazon.awssdk.services.workspacesweb.model.{
  CreateUserSettingsResponse,
  CreateNetworkSettingsResponse,
  DisassociateNetworkSettingsResponse,
  DeleteUserSettingsResponse,
  AssociateBrowserSettingsResponse,
  GetTrustStoreResponse,
  ListPortalsResponse,
  GetNetworkSettingsResponse,
  ListUserSettingsResponse,
  DeleteBrowserSettingsResponse,
  DeleteTrustStoreResponse,
  AssociateUserSettingsResponse,
  UpdateNetworkSettingsResponse,
  DisassociateUserSettingsResponse,
  ListIdentityProvidersResponse,
  UpdatePortalResponse,
  UpdateTrustStoreResponse,
  UpdateIdentityProviderResponse,
  DisassociateTrustStoreResponse,
  GetIdentityProviderResponse,
  ListTrustStoresResponse,
  UpdateBrowserSettingsResponse,
  DeleteNetworkSettingsResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  AssociateTrustStoreResponse,
  CreateBrowserSettingsResponse,
  DisassociateBrowserSettingsResponse,
  GetPortalServiceProviderMetadataResponse,
  GetBrowserSettingsResponse,
  UpdateUserSettingsResponse,
  CreateIdentityProviderResponse,
  CreatePortalResponse,
  ListBrowserSettingsResponse,
  ListNetworkSettingsResponse,
  CreateTrustStoreResponse,
  GetTrustStoreCertificateResponse,
  DeletePortalResponse,
  TagResourceResponse,
  AssociateNetworkSettingsResponse,
  ListTrustStoreCertificatesResponse,
  DeleteIdentityProviderResponse,
  GetUserSettingsResponse,
  GetPortalResponse
}
import scala.jdk.CollectionConverters._
trait WorkSpacesWeb extends AspectSupport[WorkSpacesWeb] {
  val api: WorkSpacesWebAsyncClient
  def listNetworkSettings(request: ListNetworkSettingsRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.ListNetworkSettingsResponse.ReadOnly
  ]
  def createIdentityProvider(request: CreateIdentityProviderRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.CreateIdentityProviderResponse.ReadOnly
  ]
  def createBrowserSettings(request: CreateBrowserSettingsRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.CreateBrowserSettingsResponse.ReadOnly
  ]
  def createPortal(
      request: CreatePortalRequest
  ): IO[AwsError, zio.aws.workspacesweb.model.CreatePortalResponse.ReadOnly]
  def listPortals(
      request: ListPortalsRequest
  ): IO[AwsError, zio.aws.workspacesweb.model.ListPortalsResponse.ReadOnly]
  def associateTrustStore(request: AssociateTrustStoreRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.AssociateTrustStoreResponse.ReadOnly
  ]
  def listTrustStores(
      request: ListTrustStoresRequest
  ): IO[AwsError, zio.aws.workspacesweb.model.ListTrustStoresResponse.ReadOnly]
  def deletePortal(
      request: DeletePortalRequest
  ): IO[AwsError, zio.aws.workspacesweb.model.DeletePortalResponse.ReadOnly]
  def getNetworkSettings(request: GetNetworkSettingsRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.GetNetworkSettingsResponse.ReadOnly
  ]
  def disassociateUserSettings(request: DisassociateUserSettingsRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.DisassociateUserSettingsResponse.ReadOnly
  ]
  def getTrustStoreCertificate(request: GetTrustStoreCertificateRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.GetTrustStoreCertificateResponse.ReadOnly
  ]
  def createTrustStore(
      request: CreateTrustStoreRequest
  ): IO[AwsError, zio.aws.workspacesweb.model.CreateTrustStoreResponse.ReadOnly]
  def getTrustStore(
      request: GetTrustStoreRequest
  ): IO[AwsError, zio.aws.workspacesweb.model.GetTrustStoreResponse.ReadOnly]
  def deleteBrowserSettings(request: DeleteBrowserSettingsRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.DeleteBrowserSettingsResponse.ReadOnly
  ]
  def createNetworkSettings(request: CreateNetworkSettingsRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.CreateNetworkSettingsResponse.ReadOnly
  ]
  def deleteIdentityProvider(request: DeleteIdentityProviderRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.DeleteIdentityProviderResponse.ReadOnly
  ]
  def disassociateTrustStore(request: DisassociateTrustStoreRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.DisassociateTrustStoreResponse.ReadOnly
  ]
  def updateTrustStore(
      request: UpdateTrustStoreRequest
  ): IO[AwsError, zio.aws.workspacesweb.model.UpdateTrustStoreResponse.ReadOnly]
  def getPortalServiceProviderMetadata(
      request: GetPortalServiceProviderMetadataRequest
  ): IO[
    AwsError,
    zio.aws.workspacesweb.model.GetPortalServiceProviderMetadataResponse.ReadOnly
  ]
  def getIdentityProvider(request: GetIdentityProviderRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.GetIdentityProviderResponse.ReadOnly
  ]
  def listBrowserSettings(request: ListBrowserSettingsRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.ListBrowserSettingsResponse.ReadOnly
  ]
  def updateIdentityProvider(request: UpdateIdentityProviderRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.UpdateIdentityProviderResponse.ReadOnly
  ]
  def getUserSettings(
      request: GetUserSettingsRequest
  ): IO[AwsError, zio.aws.workspacesweb.model.GetUserSettingsResponse.ReadOnly]
  def listTrustStoreCertificates(
      request: ListTrustStoreCertificatesRequest
  ): IO[
    AwsError,
    zio.aws.workspacesweb.model.ListTrustStoreCertificatesResponse.ReadOnly
  ]
  def disassociateNetworkSettings(
      request: DisassociateNetworkSettingsRequest
  ): IO[
    AwsError,
    zio.aws.workspacesweb.model.DisassociateNetworkSettingsResponse.ReadOnly
  ]
  def listIdentityProviders(request: ListIdentityProvidersRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.ListIdentityProvidersResponse.ReadOnly
  ]
  def updateUserSettings(request: UpdateUserSettingsRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.UpdateUserSettingsResponse.ReadOnly
  ]
  def updateBrowserSettings(request: UpdateBrowserSettingsRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.UpdateBrowserSettingsResponse.ReadOnly
  ]
  def listUserSettings(
      request: ListUserSettingsRequest
  ): IO[AwsError, zio.aws.workspacesweb.model.ListUserSettingsResponse.ReadOnly]
  def associateNetworkSettings(
      request: AssociateNetworkSettingsRequest
  ): IO[AwsError, ReadOnly]
  def createUserSettings(request: CreateUserSettingsRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.CreateUserSettingsResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.workspacesweb.model.UntagResourceResponse.ReadOnly]
  def associateBrowserSettings(request: AssociateBrowserSettingsRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.AssociateBrowserSettingsResponse.ReadOnly
  ]
  def deleteTrustStore(
      request: DeleteTrustStoreRequest
  ): IO[AwsError, zio.aws.workspacesweb.model.DeleteTrustStoreResponse.ReadOnly]
  def deleteUserSettings(request: DeleteUserSettingsRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.DeleteUserSettingsResponse.ReadOnly
  ]
  def updatePortal(
      request: UpdatePortalRequest
  ): IO[AwsError, zio.aws.workspacesweb.model.UpdatePortalResponse.ReadOnly]
  def deleteNetworkSettings(request: DeleteNetworkSettingsRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.DeleteNetworkSettingsResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.ListTagsForResourceResponse.ReadOnly
  ]
  def getPortal(
      request: GetPortalRequest
  ): IO[AwsError, zio.aws.workspacesweb.model.GetPortalResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.workspacesweb.model.TagResourceResponse.ReadOnly]
  def disassociateBrowserSettings(
      request: DisassociateBrowserSettingsRequest
  ): IO[
    AwsError,
    zio.aws.workspacesweb.model.DisassociateBrowserSettingsResponse.ReadOnly
  ]
  def updateNetworkSettings(request: UpdateNetworkSettingsRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.UpdateNetworkSettingsResponse.ReadOnly
  ]
  def getBrowserSettings(request: GetBrowserSettingsRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.GetBrowserSettingsResponse.ReadOnly
  ]
  def associateUserSettings(request: AssociateUserSettingsRequest): IO[
    AwsError,
    zio.aws.workspacesweb.model.AssociateUserSettingsResponse.ReadOnly
  ]
}
object WorkSpacesWeb {
  val live: ZLayer[AwsConfig, java.lang.Throwable, WorkSpacesWeb] = customized(
    identity
  )
  def customized(
      customization: WorkSpacesWebAsyncClientBuilder => WorkSpacesWebAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, WorkSpacesWeb] = managed(
    customization
  ).toLayer
  def managed(
      customization: WorkSpacesWebAsyncClientBuilder => WorkSpacesWebAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, WorkSpacesWeb] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = WorkSpacesWebAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[WorkSpacesWebAsyncClient, WorkSpacesWebAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        WorkSpacesWebAsyncClient,
        WorkSpacesWebAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new WorkSpacesWebImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class WorkSpacesWebImpl[R](
      override val api: WorkSpacesWebAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends WorkSpacesWeb
      with AwsServiceBase[R] {
    override val serviceName: String = "WorkSpacesWeb"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): WorkSpacesWebImpl[R1] = new WorkSpacesWebImpl(api, newAspect, r)
    def listNetworkSettings(request: ListNetworkSettingsRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.ListNetworkSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest,
      ListNetworkSettingsResponse
    ]("listNetworkSettings", api.listNetworkSettings)(request.buildAwsValue())
      .map(zio.aws.workspacesweb.model.ListNetworkSettingsResponse.wrap)
      .provideEnvironment(r)
    def createIdentityProvider(request: CreateIdentityProviderRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.CreateIdentityProviderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderRequest,
      CreateIdentityProviderResponse
    ]("createIdentityProvider", api.createIdentityProvider)(
      request.buildAwsValue()
    ).map(zio.aws.workspacesweb.model.CreateIdentityProviderResponse.wrap)
      .provideEnvironment(r)
    def createBrowserSettings(request: CreateBrowserSettingsRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.CreateBrowserSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsRequest,
      CreateBrowserSettingsResponse
    ]("createBrowserSettings", api.createBrowserSettings)(
      request.buildAwsValue()
    ).map(zio.aws.workspacesweb.model.CreateBrowserSettingsResponse.wrap)
      .provideEnvironment(r)
    def createPortal(
        request: CreatePortalRequest
    ): IO[AwsError, zio.aws.workspacesweb.model.CreatePortalResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.workspacesweb.model.CreatePortalRequest,
        CreatePortalResponse
      ]("createPortal", api.createPortal)(request.buildAwsValue())
        .map(zio.aws.workspacesweb.model.CreatePortalResponse.wrap)
        .provideEnvironment(r)
    def listPortals(
        request: ListPortalsRequest
    ): IO[AwsError, zio.aws.workspacesweb.model.ListPortalsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest,
        ListPortalsResponse
      ]("listPortals", api.listPortals)(request.buildAwsValue())
        .map(zio.aws.workspacesweb.model.ListPortalsResponse.wrap)
        .provideEnvironment(r)
    def associateTrustStore(request: AssociateTrustStoreRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.AssociateTrustStoreResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.AssociateTrustStoreRequest,
      AssociateTrustStoreResponse
    ]("associateTrustStore", api.associateTrustStore)(request.buildAwsValue())
      .map(zio.aws.workspacesweb.model.AssociateTrustStoreResponse.wrap)
      .provideEnvironment(r)
    def listTrustStores(request: ListTrustStoresRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.ListTrustStoresResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest,
      ListTrustStoresResponse
    ]("listTrustStores", api.listTrustStores)(request.buildAwsValue())
      .map(zio.aws.workspacesweb.model.ListTrustStoresResponse.wrap)
      .provideEnvironment(r)
    def deletePortal(
        request: DeletePortalRequest
    ): IO[AwsError, zio.aws.workspacesweb.model.DeletePortalResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.workspacesweb.model.DeletePortalRequest,
        DeletePortalResponse
      ]("deletePortal", api.deletePortal)(request.buildAwsValue())
        .map(zio.aws.workspacesweb.model.DeletePortalResponse.wrap)
        .provideEnvironment(r)
    def getNetworkSettings(request: GetNetworkSettingsRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.GetNetworkSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsRequest,
      GetNetworkSettingsResponse
    ]("getNetworkSettings", api.getNetworkSettings)(request.buildAwsValue())
      .map(zio.aws.workspacesweb.model.GetNetworkSettingsResponse.wrap)
      .provideEnvironment(r)
    def disassociateUserSettings(request: DisassociateUserSettingsRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.DisassociateUserSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.DisassociateUserSettingsRequest,
      DisassociateUserSettingsResponse
    ]("disassociateUserSettings", api.disassociateUserSettings)(
      request.buildAwsValue()
    ).map(zio.aws.workspacesweb.model.DisassociateUserSettingsResponse.wrap)
      .provideEnvironment(r)
    def getTrustStoreCertificate(request: GetTrustStoreCertificateRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.GetTrustStoreCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateRequest,
      GetTrustStoreCertificateResponse
    ]("getTrustStoreCertificate", api.getTrustStoreCertificate)(
      request.buildAwsValue()
    ).map(zio.aws.workspacesweb.model.GetTrustStoreCertificateResponse.wrap)
      .provideEnvironment(r)
    def createTrustStore(request: CreateTrustStoreRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.CreateTrustStoreResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreRequest,
      CreateTrustStoreResponse
    ]("createTrustStore", api.createTrustStore)(request.buildAwsValue())
      .map(zio.aws.workspacesweb.model.CreateTrustStoreResponse.wrap)
      .provideEnvironment(r)
    def getTrustStore(request: GetTrustStoreRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.GetTrustStoreResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreRequest,
      GetTrustStoreResponse
    ]("getTrustStore", api.getTrustStore)(request.buildAwsValue())
      .map(zio.aws.workspacesweb.model.GetTrustStoreResponse.wrap)
      .provideEnvironment(r)
    def deleteBrowserSettings(request: DeleteBrowserSettingsRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.DeleteBrowserSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.DeleteBrowserSettingsRequest,
      DeleteBrowserSettingsResponse
    ]("deleteBrowserSettings", api.deleteBrowserSettings)(
      request.buildAwsValue()
    ).map(zio.aws.workspacesweb.model.DeleteBrowserSettingsResponse.wrap)
      .provideEnvironment(r)
    def createNetworkSettings(request: CreateNetworkSettingsRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.CreateNetworkSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsRequest,
      CreateNetworkSettingsResponse
    ]("createNetworkSettings", api.createNetworkSettings)(
      request.buildAwsValue()
    ).map(zio.aws.workspacesweb.model.CreateNetworkSettingsResponse.wrap)
      .provideEnvironment(r)
    def deleteIdentityProvider(request: DeleteIdentityProviderRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.DeleteIdentityProviderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.DeleteIdentityProviderRequest,
      DeleteIdentityProviderResponse
    ]("deleteIdentityProvider", api.deleteIdentityProvider)(
      request.buildAwsValue()
    ).map(zio.aws.workspacesweb.model.DeleteIdentityProviderResponse.wrap)
      .provideEnvironment(r)
    def disassociateTrustStore(request: DisassociateTrustStoreRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.DisassociateTrustStoreResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.DisassociateTrustStoreRequest,
      DisassociateTrustStoreResponse
    ]("disassociateTrustStore", api.disassociateTrustStore)(
      request.buildAwsValue()
    ).map(zio.aws.workspacesweb.model.DisassociateTrustStoreResponse.wrap)
      .provideEnvironment(r)
    def updateTrustStore(request: UpdateTrustStoreRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.UpdateTrustStoreResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreRequest,
      UpdateTrustStoreResponse
    ]("updateTrustStore", api.updateTrustStore)(request.buildAwsValue())
      .map(zio.aws.workspacesweb.model.UpdateTrustStoreResponse.wrap)
      .provideEnvironment(r)
    def getPortalServiceProviderMetadata(
        request: GetPortalServiceProviderMetadataRequest
    ): IO[
      AwsError,
      zio.aws.workspacesweb.model.GetPortalServiceProviderMetadataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataRequest,
      GetPortalServiceProviderMetadataResponse
    ]("getPortalServiceProviderMetadata", api.getPortalServiceProviderMetadata)(
      request.buildAwsValue()
    ).map(
      zio.aws.workspacesweb.model.GetPortalServiceProviderMetadataResponse.wrap
    ).provideEnvironment(r)
    def getIdentityProvider(request: GetIdentityProviderRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.GetIdentityProviderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderRequest,
      GetIdentityProviderResponse
    ]("getIdentityProvider", api.getIdentityProvider)(request.buildAwsValue())
      .map(zio.aws.workspacesweb.model.GetIdentityProviderResponse.wrap)
      .provideEnvironment(r)
    def listBrowserSettings(request: ListBrowserSettingsRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.ListBrowserSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest,
      ListBrowserSettingsResponse
    ]("listBrowserSettings", api.listBrowserSettings)(request.buildAwsValue())
      .map(zio.aws.workspacesweb.model.ListBrowserSettingsResponse.wrap)
      .provideEnvironment(r)
    def updateIdentityProvider(request: UpdateIdentityProviderRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.UpdateIdentityProviderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.UpdateIdentityProviderRequest,
      UpdateIdentityProviderResponse
    ]("updateIdentityProvider", api.updateIdentityProvider)(
      request.buildAwsValue()
    ).map(zio.aws.workspacesweb.model.UpdateIdentityProviderResponse.wrap)
      .provideEnvironment(r)
    def getUserSettings(request: GetUserSettingsRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.GetUserSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.GetUserSettingsRequest,
      GetUserSettingsResponse
    ]("getUserSettings", api.getUserSettings)(request.buildAwsValue())
      .map(zio.aws.workspacesweb.model.GetUserSettingsResponse.wrap)
      .provideEnvironment(r)
    def listTrustStoreCertificates(
        request: ListTrustStoreCertificatesRequest
    ): IO[
      AwsError,
      zio.aws.workspacesweb.model.ListTrustStoreCertificatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest,
      ListTrustStoreCertificatesResponse
    ]("listTrustStoreCertificates", api.listTrustStoreCertificates)(
      request.buildAwsValue()
    ).map(zio.aws.workspacesweb.model.ListTrustStoreCertificatesResponse.wrap)
      .provideEnvironment(r)
    def disassociateNetworkSettings(
        request: DisassociateNetworkSettingsRequest
    ): IO[
      AwsError,
      zio.aws.workspacesweb.model.DisassociateNetworkSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.DisassociateNetworkSettingsRequest,
      DisassociateNetworkSettingsResponse
    ]("disassociateNetworkSettings", api.disassociateNetworkSettings)(
      request.buildAwsValue()
    ).map(zio.aws.workspacesweb.model.DisassociateNetworkSettingsResponse.wrap)
      .provideEnvironment(r)
    def listIdentityProviders(request: ListIdentityProvidersRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.ListIdentityProvidersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest,
      ListIdentityProvidersResponse
    ]("listIdentityProviders", api.listIdentityProviders)(
      request.buildAwsValue()
    ).map(zio.aws.workspacesweb.model.ListIdentityProvidersResponse.wrap)
      .provideEnvironment(r)
    def updateUserSettings(request: UpdateUserSettingsRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.UpdateUserSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsRequest,
      UpdateUserSettingsResponse
    ]("updateUserSettings", api.updateUserSettings)(request.buildAwsValue())
      .map(zio.aws.workspacesweb.model.UpdateUserSettingsResponse.wrap)
      .provideEnvironment(r)
    def updateBrowserSettings(request: UpdateBrowserSettingsRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.UpdateBrowserSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsRequest,
      UpdateBrowserSettingsResponse
    ]("updateBrowserSettings", api.updateBrowserSettings)(
      request.buildAwsValue()
    ).map(zio.aws.workspacesweb.model.UpdateBrowserSettingsResponse.wrap)
      .provideEnvironment(r)
    def listUserSettings(request: ListUserSettingsRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.ListUserSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest,
      ListUserSettingsResponse
    ]("listUserSettings", api.listUserSettings)(request.buildAwsValue())
      .map(zio.aws.workspacesweb.model.ListUserSettingsResponse.wrap)
      .provideEnvironment(r)
    def associateNetworkSettings(
        request: AssociateNetworkSettingsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsRequest,
      AssociateNetworkSettingsResponse
    ]("associateNetworkSettings", api.associateNetworkSettings)(
      request.buildAwsValue()
    ).map(zio.aws.workspacesweb.model.AssociateNetworkSettingsResponse.wrap)
      .provideEnvironment(r)
    def createUserSettings(request: CreateUserSettingsRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.CreateUserSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsRequest,
      CreateUserSettingsResponse
    ]("createUserSettings", api.createUserSettings)(request.buildAwsValue())
      .map(zio.aws.workspacesweb.model.CreateUserSettingsResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.workspacesweb.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def associateBrowserSettings(request: AssociateBrowserSettingsRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.AssociateBrowserSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsRequest,
      AssociateBrowserSettingsResponse
    ]("associateBrowserSettings", api.associateBrowserSettings)(
      request.buildAwsValue()
    ).map(zio.aws.workspacesweb.model.AssociateBrowserSettingsResponse.wrap)
      .provideEnvironment(r)
    def deleteTrustStore(request: DeleteTrustStoreRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.DeleteTrustStoreResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.DeleteTrustStoreRequest,
      DeleteTrustStoreResponse
    ]("deleteTrustStore", api.deleteTrustStore)(request.buildAwsValue())
      .map(zio.aws.workspacesweb.model.DeleteTrustStoreResponse.wrap)
      .provideEnvironment(r)
    def deleteUserSettings(request: DeleteUserSettingsRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.DeleteUserSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.DeleteUserSettingsRequest,
      DeleteUserSettingsResponse
    ]("deleteUserSettings", api.deleteUserSettings)(request.buildAwsValue())
      .map(zio.aws.workspacesweb.model.DeleteUserSettingsResponse.wrap)
      .provideEnvironment(r)
    def updatePortal(
        request: UpdatePortalRequest
    ): IO[AwsError, zio.aws.workspacesweb.model.UpdatePortalResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.workspacesweb.model.UpdatePortalRequest,
        UpdatePortalResponse
      ]("updatePortal", api.updatePortal)(request.buildAwsValue())
        .map(zio.aws.workspacesweb.model.UpdatePortalResponse.wrap)
        .provideEnvironment(r)
    def deleteNetworkSettings(request: DeleteNetworkSettingsRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.DeleteNetworkSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.DeleteNetworkSettingsRequest,
      DeleteNetworkSettingsResponse
    ]("deleteNetworkSettings", api.deleteNetworkSettings)(
      request.buildAwsValue()
    ).map(zio.aws.workspacesweb.model.DeleteNetworkSettingsResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.workspacesweb.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def getPortal(
        request: GetPortalRequest
    ): IO[AwsError, zio.aws.workspacesweb.model.GetPortalResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.workspacesweb.model.GetPortalRequest,
        GetPortalResponse
      ]("getPortal", api.getPortal)(request.buildAwsValue())
        .map(zio.aws.workspacesweb.model.GetPortalResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.workspacesweb.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.workspacesweb.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.workspacesweb.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def disassociateBrowserSettings(
        request: DisassociateBrowserSettingsRequest
    ): IO[
      AwsError,
      zio.aws.workspacesweb.model.DisassociateBrowserSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.DisassociateBrowserSettingsRequest,
      DisassociateBrowserSettingsResponse
    ]("disassociateBrowserSettings", api.disassociateBrowserSettings)(
      request.buildAwsValue()
    ).map(zio.aws.workspacesweb.model.DisassociateBrowserSettingsResponse.wrap)
      .provideEnvironment(r)
    def updateNetworkSettings(request: UpdateNetworkSettingsRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.UpdateNetworkSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsRequest,
      UpdateNetworkSettingsResponse
    ]("updateNetworkSettings", api.updateNetworkSettings)(
      request.buildAwsValue()
    ).map(zio.aws.workspacesweb.model.UpdateNetworkSettingsResponse.wrap)
      .provideEnvironment(r)
    def getBrowserSettings(request: GetBrowserSettingsRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.GetBrowserSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsRequest,
      GetBrowserSettingsResponse
    ]("getBrowserSettings", api.getBrowserSettings)(request.buildAwsValue())
      .map(zio.aws.workspacesweb.model.GetBrowserSettingsResponse.wrap)
      .provideEnvironment(r)
    def associateUserSettings(request: AssociateUserSettingsRequest): IO[
      AwsError,
      zio.aws.workspacesweb.model.AssociateUserSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.workspacesweb.model.AssociateUserSettingsRequest,
      AssociateUserSettingsResponse
    ]("associateUserSettings", api.associateUserSettings)(
      request.buildAwsValue()
    ).map(zio.aws.workspacesweb.model.AssociateUserSettingsResponse.wrap)
      .provideEnvironment(r)
  }
  def listNetworkSettings(request: ListNetworkSettingsRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.ListNetworkSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNetworkSettings(request))
  def createIdentityProvider(request: CreateIdentityProviderRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.CreateIdentityProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createIdentityProvider(request))
  def createBrowserSettings(request: CreateBrowserSettingsRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.CreateBrowserSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBrowserSettings(request))
  def createPortal(request: CreatePortalRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.CreatePortalResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPortal(request))
  def listPortals(request: ListPortalsRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.ListPortalsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPortals(request))
  def associateTrustStore(request: AssociateTrustStoreRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.AssociateTrustStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateTrustStore(request))
  def listTrustStores(request: ListTrustStoresRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.ListTrustStoresResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTrustStores(request))
  def deletePortal(request: DeletePortalRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.DeletePortalResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePortal(request))
  def getNetworkSettings(request: GetNetworkSettingsRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.GetNetworkSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getNetworkSettings(request))
  def disassociateUserSettings(request: DisassociateUserSettingsRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.DisassociateUserSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateUserSettings(request))
  def getTrustStoreCertificate(request: GetTrustStoreCertificateRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.GetTrustStoreCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTrustStoreCertificate(request))
  def createTrustStore(request: CreateTrustStoreRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.CreateTrustStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTrustStore(request))
  def getTrustStore(request: GetTrustStoreRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.GetTrustStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTrustStore(request))
  def deleteBrowserSettings(request: DeleteBrowserSettingsRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.DeleteBrowserSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBrowserSettings(request))
  def createNetworkSettings(request: CreateNetworkSettingsRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.CreateNetworkSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNetworkSettings(request))
  def deleteIdentityProvider(request: DeleteIdentityProviderRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.DeleteIdentityProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteIdentityProvider(request))
  def disassociateTrustStore(request: DisassociateTrustStoreRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.DisassociateTrustStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateTrustStore(request))
  def updateTrustStore(request: UpdateTrustStoreRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.UpdateTrustStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTrustStore(request))
  def getPortalServiceProviderMetadata(
      request: GetPortalServiceProviderMetadataRequest
  ): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.GetPortalServiceProviderMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPortalServiceProviderMetadata(request))
  def getIdentityProvider(request: GetIdentityProviderRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.GetIdentityProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIdentityProvider(request))
  def listBrowserSettings(request: ListBrowserSettingsRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.ListBrowserSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBrowserSettings(request))
  def updateIdentityProvider(request: UpdateIdentityProviderRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.UpdateIdentityProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateIdentityProvider(request))
  def getUserSettings(request: GetUserSettingsRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.GetUserSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUserSettings(request))
  def listTrustStoreCertificates(
      request: ListTrustStoreCertificatesRequest
  ): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.ListTrustStoreCertificatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTrustStoreCertificates(request))
  def disassociateNetworkSettings(
      request: DisassociateNetworkSettingsRequest
  ): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.DisassociateNetworkSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateNetworkSettings(request))
  def listIdentityProviders(request: ListIdentityProvidersRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.ListIdentityProvidersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listIdentityProviders(request))
  def updateUserSettings(request: UpdateUserSettingsRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.UpdateUserSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateUserSettings(request))
  def updateBrowserSettings(request: UpdateBrowserSettingsRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.UpdateBrowserSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBrowserSettings(request))
  def listUserSettings(request: ListUserSettingsRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.ListUserSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUserSettings(request))
  def associateNetworkSettings(
      request: AssociateNetworkSettingsRequest
  ): ZIO[zio.aws.workspacesweb.WorkSpacesWeb, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.associateNetworkSettings(request))
  def createUserSettings(request: CreateUserSettingsRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.CreateUserSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUserSettings(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def associateBrowserSettings(request: AssociateBrowserSettingsRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.AssociateBrowserSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateBrowserSettings(request))
  def deleteTrustStore(request: DeleteTrustStoreRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.DeleteTrustStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTrustStore(request))
  def deleteUserSettings(request: DeleteUserSettingsRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.DeleteUserSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteUserSettings(request))
  def updatePortal(request: UpdatePortalRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.UpdatePortalResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePortal(request))
  def deleteNetworkSettings(request: DeleteNetworkSettingsRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.DeleteNetworkSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteNetworkSettings(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def getPortal(request: GetPortalRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.GetPortalResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPortal(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def disassociateBrowserSettings(
      request: DisassociateBrowserSettingsRequest
  ): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.DisassociateBrowserSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateBrowserSettings(request))
  def updateNetworkSettings(request: UpdateNetworkSettingsRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.UpdateNetworkSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateNetworkSettings(request))
  def getBrowserSettings(request: GetBrowserSettingsRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.GetBrowserSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBrowserSettings(request))
  def associateUserSettings(request: AssociateUserSettingsRequest): ZIO[
    zio.aws.workspacesweb.WorkSpacesWeb,
    AwsError,
    zio.aws.workspacesweb.model.AssociateUserSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateUserSettings(request))
}
