package zio.aws.workspacesweb.model
import zio.aws.workspacesweb.model.primitives.{
  DisplayName,
  Description,
  Timestamp,
  ARN
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class IpAccessSettings(
    associatedPortalArns: Optional[Iterable[ARN]] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    displayName: Optional[DisplayName] = Optional.Absent,
    ipAccessSettingsArn: ARN,
    ipRules: Optional[Iterable[zio.aws.workspacesweb.model.IpRule]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.IpAccessSettings = {
    import IpAccessSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.IpAccessSettings
      .builder()
      .optionallyWith(
        associatedPortalArns.map(value =>
          value.map { item =>
            ARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.associatedPortalArns)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .ipAccessSettingsArn(ARN.unwrap(ipAccessSettingsArn): java.lang.String)
      .optionallyWith(
        ipRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipRules)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.IpAccessSettings.ReadOnly =
    zio.aws.workspacesweb.model.IpAccessSettings.wrap(buildAwsValue())
}
object IpAccessSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.IpAccessSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.IpAccessSettings =
      zio.aws.workspacesweb.model.IpAccessSettings(
        associatedPortalArns.map(value => value),
        creationDate.map(value => value),
        description.map(value => value),
        displayName.map(value => value),
        ipAccessSettingsArn,
        ipRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def associatedPortalArns: Optional[List[ARN]]
    def creationDate: Optional[Timestamp]
    def description: Optional[Description]
    def displayName: Optional[DisplayName]
    def ipAccessSettingsArn: ARN
    def ipRules: Optional[List[zio.aws.workspacesweb.model.IpRule.ReadOnly]]
    def getAssociatedPortalArns: ZIO[Any, AwsError, List[ARN]] =
      AwsError.unwrapOptionField("associatedPortalArns", associatedPortalArns)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getIpAccessSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(ipAccessSettingsArn)
    def getIpRules: ZIO[Any, AwsError, List[
      zio.aws.workspacesweb.model.IpRule.ReadOnly
    ]] = AwsError.unwrapOptionField("ipRules", ipRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.IpAccessSettings
  ) extends zio.aws.workspacesweb.model.IpAccessSettings.ReadOnly {
    override val associatedPortalArns: Optional[List[ARN]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedPortalArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspacesweb.model.primitives.ARN(item)
          }.toList
        )
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.workspacesweb.model.primitives.Timestamp(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.workspacesweb.model.primitives.Description(value))
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.workspacesweb.model.primitives.DisplayName(value))
    override val ipAccessSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.ipAccessSettingsArn())
    override val ipRules
        : Optional[List[zio.aws.workspacesweb.model.IpRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspacesweb.model.IpRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.IpAccessSettings
  ): zio.aws.workspacesweb.model.IpAccessSettings.ReadOnly = new Wrapper(impl)
}
