package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetUserAccessLoggingSettingsResponse(
    userAccessLoggingSettings: Optional[
      zio.aws.workspacesweb.model.UserAccessLoggingSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.GetUserAccessLoggingSettingsResponse = {
    import GetUserAccessLoggingSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.GetUserAccessLoggingSettingsResponse
      .builder()
      .optionallyWith(
        userAccessLoggingSettings.map(value => value.buildAwsValue())
      )(_.userAccessLoggingSettings)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.GetUserAccessLoggingSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.GetUserAccessLoggingSettingsResponse
      .wrap(buildAwsValue())
}
object GetUserAccessLoggingSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.GetUserAccessLoggingSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.GetUserAccessLoggingSettingsResponse =
      zio.aws.workspacesweb.model.GetUserAccessLoggingSettingsResponse(
        userAccessLoggingSettings.map(value => value.asEditable)
      )
    def userAccessLoggingSettings: Optional[
      zio.aws.workspacesweb.model.UserAccessLoggingSettings.ReadOnly
    ]
    def getUserAccessLoggingSettings: ZIO[
      Any,
      AwsError,
      zio.aws.workspacesweb.model.UserAccessLoggingSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "userAccessLoggingSettings",
      userAccessLoggingSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetUserAccessLoggingSettingsResponse
  ) extends zio.aws.workspacesweb.model.GetUserAccessLoggingSettingsResponse.ReadOnly {
    override val userAccessLoggingSettings: Optional[
      zio.aws.workspacesweb.model.UserAccessLoggingSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.userAccessLoggingSettings())
      .map(value =>
        zio.aws.workspacesweb.model.UserAccessLoggingSettings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetUserAccessLoggingSettingsResponse
  ): zio.aws.workspacesweb.model.GetUserAccessLoggingSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
