package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class CreateIpAccessSettingsResponse(ipAccessSettingsArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.CreateIpAccessSettingsResponse = {
    import CreateIpAccessSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.CreateIpAccessSettingsResponse
      .builder()
      .ipAccessSettingsArn(ARN.unwrap(ipAccessSettingsArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.CreateIpAccessSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.CreateIpAccessSettingsResponse
      .wrap(buildAwsValue())
}
object CreateIpAccessSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.CreateIpAccessSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.CreateIpAccessSettingsResponse =
      zio.aws.workspacesweb.model
        .CreateIpAccessSettingsResponse(ipAccessSettingsArn)
    def ipAccessSettingsArn: ARN
    def getIpAccessSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(ipAccessSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateIpAccessSettingsResponse
  ) extends zio.aws.workspacesweb.model.CreateIpAccessSettingsResponse.ReadOnly {
    override val ipAccessSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.ipAccessSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateIpAccessSettingsResponse
  ): zio.aws.workspacesweb.model.CreateIpAccessSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
