package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class CreateUserSettingsResponse(userSettingsArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsResponse = {
    import CreateUserSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsResponse
      .builder()
      .userSettingsArn(ARN.unwrap(userSettingsArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.CreateUserSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.CreateUserSettingsResponse.wrap(buildAwsValue())
}
object CreateUserSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.CreateUserSettingsResponse =
      zio.aws.workspacesweb.model.CreateUserSettingsResponse(userSettingsArn)
    def userSettingsArn: ARN
    def getUserSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(userSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsResponse
  ) extends zio.aws.workspacesweb.model.CreateUserSettingsResponse.ReadOnly {
    override val userSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.userSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsResponse
  ): zio.aws.workspacesweb.model.CreateUserSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
