package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.{IpRange, Description}
import scala.jdk.CollectionConverters._
final case class IpRule(
    description: Optional[Description] = Optional.Absent,
    ipRange: IpRange
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.IpRule = {
    import IpRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.IpRule
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .ipRange(IpRange.unwrap(ipRange): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.IpRule.ReadOnly =
    zio.aws.workspacesweb.model.IpRule.wrap(buildAwsValue())
}
object IpRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.IpRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.IpRule =
      zio.aws.workspacesweb.model
        .IpRule(description.map(value => value), ipRange)
    def description: Optional[Description]
    def ipRange: IpRange
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getIpRange: ZIO[Any, Nothing, IpRange] = ZIO.succeed(ipRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.IpRule
  ) extends zio.aws.workspacesweb.model.IpRule.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.workspacesweb.model.primitives.Description(value))
    override val ipRange: IpRange =
      zio.aws.workspacesweb.model.primitives.IpRange(impl.ipRange())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.IpRule
  ): zio.aws.workspacesweb.model.IpRule.ReadOnly = new Wrapper(impl)
}
