package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class GetIpAccessSettingsRequest(ipAccessSettingsArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.GetIpAccessSettingsRequest = {
    import GetIpAccessSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.GetIpAccessSettingsRequest
      .builder()
      .ipAccessSettingsArn(ARN.unwrap(ipAccessSettingsArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.GetIpAccessSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.GetIpAccessSettingsRequest.wrap(buildAwsValue())
}
object GetIpAccessSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.GetIpAccessSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.GetIpAccessSettingsRequest =
      zio.aws.workspacesweb.model
        .GetIpAccessSettingsRequest(ipAccessSettingsArn)
    def ipAccessSettingsArn: ARN
    def getIpAccessSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(ipAccessSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetIpAccessSettingsRequest
  ) extends zio.aws.workspacesweb.model.GetIpAccessSettingsRequest.ReadOnly {
    override val ipAccessSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.ipAccessSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetIpAccessSettingsRequest
  ): zio.aws.workspacesweb.model.GetIpAccessSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
