package zio.aws.workspacesweb.model
import zio.aws.workspacesweb.model.primitives.{
  ARN,
  IdleDisconnectTimeoutInMinutes,
  DisconnectTimeoutInMinutes
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UserSettingsSummary(
    copyAllowed: Optional[zio.aws.workspacesweb.model.EnabledType] =
      Optional.Absent,
    disconnectTimeoutInMinutes: Optional[DisconnectTimeoutInMinutes] =
      Optional.Absent,
    downloadAllowed: Optional[zio.aws.workspacesweb.model.EnabledType] =
      Optional.Absent,
    idleDisconnectTimeoutInMinutes: Optional[IdleDisconnectTimeoutInMinutes] =
      Optional.Absent,
    pasteAllowed: Optional[zio.aws.workspacesweb.model.EnabledType] =
      Optional.Absent,
    printAllowed: Optional[zio.aws.workspacesweb.model.EnabledType] =
      Optional.Absent,
    uploadAllowed: Optional[zio.aws.workspacesweb.model.EnabledType] =
      Optional.Absent,
    userSettingsArn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.UserSettingsSummary = {
    import UserSettingsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.UserSettingsSummary
      .builder()
      .optionallyWith(copyAllowed.map(value => value.unwrap))(_.copyAllowed)
      .optionallyWith(
        disconnectTimeoutInMinutes.map(value =>
          DisconnectTimeoutInMinutes.unwrap(value): Integer
        )
      )(_.disconnectTimeoutInMinutes)
      .optionallyWith(downloadAllowed.map(value => value.unwrap))(
        _.downloadAllowed
      )
      .optionallyWith(
        idleDisconnectTimeoutInMinutes.map(value =>
          IdleDisconnectTimeoutInMinutes.unwrap(value): Integer
        )
      )(_.idleDisconnectTimeoutInMinutes)
      .optionallyWith(pasteAllowed.map(value => value.unwrap))(_.pasteAllowed)
      .optionallyWith(printAllowed.map(value => value.unwrap))(_.printAllowed)
      .optionallyWith(uploadAllowed.map(value => value.unwrap))(_.uploadAllowed)
      .optionallyWith(
        userSettingsArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.userSettingsArn)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.UserSettingsSummary.ReadOnly =
    zio.aws.workspacesweb.model.UserSettingsSummary.wrap(buildAwsValue())
}
object UserSettingsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.UserSettingsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.UserSettingsSummary =
      zio.aws.workspacesweb.model.UserSettingsSummary(
        copyAllowed.map(value => value),
        disconnectTimeoutInMinutes.map(value => value),
        downloadAllowed.map(value => value),
        idleDisconnectTimeoutInMinutes.map(value => value),
        pasteAllowed.map(value => value),
        printAllowed.map(value => value),
        uploadAllowed.map(value => value),
        userSettingsArn.map(value => value)
      )
    def copyAllowed: Optional[zio.aws.workspacesweb.model.EnabledType]
    def disconnectTimeoutInMinutes: Optional[DisconnectTimeoutInMinutes]
    def downloadAllowed: Optional[zio.aws.workspacesweb.model.EnabledType]
    def idleDisconnectTimeoutInMinutes: Optional[IdleDisconnectTimeoutInMinutes]
    def pasteAllowed: Optional[zio.aws.workspacesweb.model.EnabledType]
    def printAllowed: Optional[zio.aws.workspacesweb.model.EnabledType]
    def uploadAllowed: Optional[zio.aws.workspacesweb.model.EnabledType]
    def userSettingsArn: Optional[ARN]
    def getCopyAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("copyAllowed", copyAllowed)
    def getDisconnectTimeoutInMinutes
        : ZIO[Any, AwsError, DisconnectTimeoutInMinutes] =
      AwsError.unwrapOptionField(
        "disconnectTimeoutInMinutes",
        disconnectTimeoutInMinutes
      )
    def getDownloadAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("downloadAllowed", downloadAllowed)
    def getIdleDisconnectTimeoutInMinutes
        : ZIO[Any, AwsError, IdleDisconnectTimeoutInMinutes] =
      AwsError.unwrapOptionField(
        "idleDisconnectTimeoutInMinutes",
        idleDisconnectTimeoutInMinutes
      )
    def getPasteAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("pasteAllowed", pasteAllowed)
    def getPrintAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("printAllowed", printAllowed)
    def getUploadAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("uploadAllowed", uploadAllowed)
    def getUserSettingsArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("userSettingsArn", userSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.UserSettingsSummary
  ) extends zio.aws.workspacesweb.model.UserSettingsSummary.ReadOnly {
    override val copyAllowed
        : Optional[zio.aws.workspacesweb.model.EnabledType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val disconnectTimeoutInMinutes
        : Optional[DisconnectTimeoutInMinutes] = zio.aws.core.internal
      .optionalFromNullable(impl.disconnectTimeoutInMinutes())
      .map(value =>
        zio.aws.workspacesweb.model.primitives.DisconnectTimeoutInMinutes(value)
      )
    override val downloadAllowed
        : Optional[zio.aws.workspacesweb.model.EnabledType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.downloadAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val idleDisconnectTimeoutInMinutes
        : Optional[IdleDisconnectTimeoutInMinutes] = zio.aws.core.internal
      .optionalFromNullable(impl.idleDisconnectTimeoutInMinutes())
      .map(value =>
        zio.aws.workspacesweb.model.primitives
          .IdleDisconnectTimeoutInMinutes(value)
      )
    override val pasteAllowed
        : Optional[zio.aws.workspacesweb.model.EnabledType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pasteAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val printAllowed
        : Optional[zio.aws.workspacesweb.model.EnabledType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.printAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val uploadAllowed
        : Optional[zio.aws.workspacesweb.model.EnabledType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uploadAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val userSettingsArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.userSettingsArn())
      .map(value => zio.aws.workspacesweb.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.UserSettingsSummary
  ): zio.aws.workspacesweb.model.UserSettingsSummary.ReadOnly = new Wrapper(
    impl
  )
}
