package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class DeleteIpAccessSettingsRequest(ipAccessSettingsArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.DeleteIpAccessSettingsRequest = {
    import DeleteIpAccessSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.DeleteIpAccessSettingsRequest
      .builder()
      .ipAccessSettingsArn(ARN.unwrap(ipAccessSettingsArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.DeleteIpAccessSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.DeleteIpAccessSettingsRequest
      .wrap(buildAwsValue())
}
object DeleteIpAccessSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.DeleteIpAccessSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.DeleteIpAccessSettingsRequest =
      zio.aws.workspacesweb.model
        .DeleteIpAccessSettingsRequest(ipAccessSettingsArn)
    def ipAccessSettingsArn: ARN
    def getIpAccessSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(ipAccessSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.DeleteIpAccessSettingsRequest
  ) extends zio.aws.workspacesweb.model.DeleteIpAccessSettingsRequest.ReadOnly {
    override val ipAccessSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.ipAccessSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.DeleteIpAccessSettingsRequest
  ): zio.aws.workspacesweb.model.DeleteIpAccessSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
