package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateUserSettingsResponse(
    userSettings: zio.aws.workspacesweb.model.UserSettings
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsResponse = {
    import UpdateUserSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsResponse
      .builder()
      .userSettings(userSettings.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.UpdateUserSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.UpdateUserSettingsResponse.wrap(buildAwsValue())
}
object UpdateUserSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.UpdateUserSettingsResponse =
      zio.aws.workspacesweb.model
        .UpdateUserSettingsResponse(userSettings.asEditable)
    def userSettings: zio.aws.workspacesweb.model.UserSettings.ReadOnly
    def getUserSettings
        : ZIO[Any, Nothing, zio.aws.workspacesweb.model.UserSettings.ReadOnly] =
      ZIO.succeed(userSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsResponse
  ) extends zio.aws.workspacesweb.model.UpdateUserSettingsResponse.ReadOnly {
    override val userSettings
        : zio.aws.workspacesweb.model.UserSettings.ReadOnly =
      zio.aws.workspacesweb.model.UserSettings.wrap(impl.userSettings())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsResponse
  ): zio.aws.workspacesweb.model.UpdateUserSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
