package zio.aws.workspacesweb.model
import scala.jdk.CollectionConverters._
sealed trait BrowserType {
  def unwrap: software.amazon.awssdk.services.workspacesweb.model.BrowserType
}
object BrowserType {
  def wrap(
      value: software.amazon.awssdk.services.workspacesweb.model.BrowserType
  ): zio.aws.workspacesweb.model.BrowserType = value match {
    case software.amazon.awssdk.services.workspacesweb.model.BrowserType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspacesweb.model.BrowserType.CHROME =>
      val r = Chrome
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspacesweb.model.BrowserType {
    override def unwrap
        : software.amazon.awssdk.services.workspacesweb.model.BrowserType =
      software.amazon.awssdk.services.workspacesweb.model.BrowserType.UNKNOWN_TO_SDK_VERSION
  }
  case object Chrome extends zio.aws.workspacesweb.model.BrowserType {
    override def unwrap
        : software.amazon.awssdk.services.workspacesweb.model.BrowserType =
      software.amazon.awssdk.services.workspacesweb.model.BrowserType.CHROME
  }
}
