package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.{
  ARN,
  KinesisStreamArn,
  ClientToken
}
import scala.jdk.CollectionConverters._
final case class UpdateUserAccessLoggingSettingsRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    kinesisStreamArn: Optional[KinesisStreamArn] = Optional.Absent,
    userAccessLoggingSettingsArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.UpdateUserAccessLoggingSettingsRequest = {
    import UpdateUserAccessLoggingSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.UpdateUserAccessLoggingSettingsRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        kinesisStreamArn.map(value =>
          KinesisStreamArn.unwrap(value): java.lang.String
        )
      )(_.kinesisStreamArn)
      .userAccessLoggingSettingsArn(
        ARN.unwrap(userAccessLoggingSettingsArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.UpdateUserAccessLoggingSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.UpdateUserAccessLoggingSettingsRequest
      .wrap(buildAwsValue())
}
object UpdateUserAccessLoggingSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.UpdateUserAccessLoggingSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.UpdateUserAccessLoggingSettingsRequest =
      zio.aws.workspacesweb.model.UpdateUserAccessLoggingSettingsRequest(
        clientToken.map(value => value),
        kinesisStreamArn.map(value => value),
        userAccessLoggingSettingsArn
      )
    def clientToken: Optional[ClientToken]
    def kinesisStreamArn: Optional[KinesisStreamArn]
    def userAccessLoggingSettingsArn: ARN
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getKinesisStreamArn: ZIO[Any, AwsError, KinesisStreamArn] =
      AwsError.unwrapOptionField("kinesisStreamArn", kinesisStreamArn)
    def getUserAccessLoggingSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(userAccessLoggingSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateUserAccessLoggingSettingsRequest
  ) extends zio.aws.workspacesweb.model.UpdateUserAccessLoggingSettingsRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.workspacesweb.model.primitives.ClientToken(value))
    override val kinesisStreamArn: Optional[KinesisStreamArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kinesisStreamArn())
        .map(value =>
          zio.aws.workspacesweb.model.primitives.KinesisStreamArn(value)
        )
    override val userAccessLoggingSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives
        .ARN(impl.userAccessLoggingSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateUserAccessLoggingSettingsRequest
  ): zio.aws.workspacesweb.model.UpdateUserAccessLoggingSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
