package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class CreateNetworkSettingsResponse(networkSettingsArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsResponse = {
    import CreateNetworkSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsResponse
      .builder()
      .networkSettingsArn(ARN.unwrap(networkSettingsArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.CreateNetworkSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.CreateNetworkSettingsResponse
      .wrap(buildAwsValue())
}
object CreateNetworkSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.CreateNetworkSettingsResponse =
      zio.aws.workspacesweb.model
        .CreateNetworkSettingsResponse(networkSettingsArn)
    def networkSettingsArn: ARN
    def getNetworkSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(networkSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsResponse
  ) extends zio.aws.workspacesweb.model.CreateNetworkSettingsResponse.ReadOnly {
    override val networkSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.networkSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsResponse
  ): zio.aws.workspacesweb.model.CreateNetworkSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
