package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workspacesweb.model.primitives.{
  ARN,
  ClientToken,
  CertificateThumbprint,
  CertificateAuthorityBody
}
import scala.jdk.CollectionConverters._
final case class UpdateTrustStoreRequest(
    certificatesToAdd: Option[Iterable[CertificateAuthorityBody]] = None,
    certificatesToDelete: Option[Iterable[CertificateThumbprint]] = None,
    clientToken: Option[ClientToken] = None,
    trustStoreArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreRequest = {
    import UpdateTrustStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreRequest
      .builder()
      .optionallyWith(
        certificatesToAdd.map(value =>
          value.map { item =>
            software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
              item.toArray[Byte]
            )
          }.asJavaCollection
        )
      )(_.certificatesToAdd)
      .optionallyWith(
        certificatesToDelete.map(value =>
          value.map { item =>
            CertificateThumbprint.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.certificatesToDelete)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .trustStoreArn(ARN.unwrap(trustStoreArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.UpdateTrustStoreRequest.ReadOnly =
    zio.aws.workspacesweb.model.UpdateTrustStoreRequest.wrap(buildAwsValue())
}
object UpdateTrustStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.UpdateTrustStoreRequest =
      zio.aws.workspacesweb.model.UpdateTrustStoreRequest(
        certificatesToAdd.map(value => value),
        certificatesToDelete.map(value => value),
        clientToken.map(value => value),
        trustStoreArn
      )
    def certificatesToAdd: Option[List[CertificateAuthorityBody]]
    def certificatesToDelete: Option[List[CertificateThumbprint]]
    def clientToken: Option[ClientToken]
    def trustStoreArn: ARN
    def getCertificatesToAdd
        : ZIO[Any, AwsError, List[CertificateAuthorityBody]] =
      AwsError.unwrapOptionField("certificatesToAdd", certificatesToAdd)
    def getCertificatesToDelete
        : ZIO[Any, AwsError, List[CertificateThumbprint]] =
      AwsError.unwrapOptionField("certificatesToDelete", certificatesToDelete)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTrustStoreArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(trustStoreArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreRequest
  ) extends zio.aws.workspacesweb.model.UpdateTrustStoreRequest.ReadOnly {
    override val certificatesToAdd: Option[List[CertificateAuthorityBody]] =
      scala
        .Option(impl.certificatesToAdd())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspacesweb.model.primitives.CertificateAuthorityBody(
              zio.Chunk.fromArray(item.asByteArrayUnsafe())
            )
          }.toList
        )
    override val certificatesToDelete: Option[List[CertificateThumbprint]] =
      scala
        .Option(impl.certificatesToDelete())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspacesweb.model.primitives.CertificateThumbprint(item)
          }.toList
        )
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.workspacesweb.model.primitives.ClientToken(value))
    override val trustStoreArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.trustStoreArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreRequest
  ): zio.aws.workspacesweb.model.UpdateTrustStoreRequest.ReadOnly = new Wrapper(
    impl
  )
}
