package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class GetIdentityProviderRequest(identityProviderArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderRequest = {
    import GetIdentityProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderRequest
      .builder()
      .identityProviderArn(ARN.unwrap(identityProviderArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.GetIdentityProviderRequest.ReadOnly =
    zio.aws.workspacesweb.model.GetIdentityProviderRequest.wrap(buildAwsValue())
}
object GetIdentityProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.GetIdentityProviderRequest =
      zio.aws.workspacesweb.model
        .GetIdentityProviderRequest(identityProviderArn)
    def identityProviderArn: ARN
    def getIdentityProviderArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(identityProviderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderRequest
  ) extends zio.aws.workspacesweb.model.GetIdentityProviderRequest.ReadOnly {
    override val identityProviderArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.identityProviderArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderRequest
  ): zio.aws.workspacesweb.model.GetIdentityProviderRequest.ReadOnly =
    new Wrapper(impl)
}
