package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class UserSettings(
    associatedPortalArns: Option[Iterable[ARN]] = None,
    copyAllowed: Option[zio.aws.workspacesweb.model.EnabledType] = None,
    downloadAllowed: Option[zio.aws.workspacesweb.model.EnabledType] = None,
    pasteAllowed: Option[zio.aws.workspacesweb.model.EnabledType] = None,
    printAllowed: Option[zio.aws.workspacesweb.model.EnabledType] = None,
    uploadAllowed: Option[zio.aws.workspacesweb.model.EnabledType] = None,
    userSettingsArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.UserSettings = {
    import UserSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.UserSettings
      .builder()
      .optionallyWith(
        associatedPortalArns.map(value =>
          value.map { item =>
            ARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.associatedPortalArns)
      .optionallyWith(copyAllowed.map(value => value.unwrap))(_.copyAllowed)
      .optionallyWith(downloadAllowed.map(value => value.unwrap))(
        _.downloadAllowed
      )
      .optionallyWith(pasteAllowed.map(value => value.unwrap))(_.pasteAllowed)
      .optionallyWith(printAllowed.map(value => value.unwrap))(_.printAllowed)
      .optionallyWith(uploadAllowed.map(value => value.unwrap))(_.uploadAllowed)
      .userSettingsArn(ARN.unwrap(userSettingsArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.UserSettings.ReadOnly =
    zio.aws.workspacesweb.model.UserSettings.wrap(buildAwsValue())
}
object UserSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.UserSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.UserSettings =
      zio.aws.workspacesweb.model.UserSettings(
        associatedPortalArns.map(value => value),
        copyAllowed.map(value => value),
        downloadAllowed.map(value => value),
        pasteAllowed.map(value => value),
        printAllowed.map(value => value),
        uploadAllowed.map(value => value),
        userSettingsArn
      )
    def associatedPortalArns: Option[List[ARN]]
    def copyAllowed: Option[zio.aws.workspacesweb.model.EnabledType]
    def downloadAllowed: Option[zio.aws.workspacesweb.model.EnabledType]
    def pasteAllowed: Option[zio.aws.workspacesweb.model.EnabledType]
    def printAllowed: Option[zio.aws.workspacesweb.model.EnabledType]
    def uploadAllowed: Option[zio.aws.workspacesweb.model.EnabledType]
    def userSettingsArn: ARN
    def getAssociatedPortalArns: ZIO[Any, AwsError, List[ARN]] =
      AwsError.unwrapOptionField("associatedPortalArns", associatedPortalArns)
    def getCopyAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("copyAllowed", copyAllowed)
    def getDownloadAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("downloadAllowed", downloadAllowed)
    def getPasteAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("pasteAllowed", pasteAllowed)
    def getPrintAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("printAllowed", printAllowed)
    def getUploadAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("uploadAllowed", uploadAllowed)
    def getUserSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(userSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.UserSettings
  ) extends zio.aws.workspacesweb.model.UserSettings.ReadOnly {
    override val associatedPortalArns: Option[List[ARN]] = scala
      .Option(impl.associatedPortalArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspacesweb.model.primitives.ARN(item)
        }.toList
      )
    override val copyAllowed: Option[zio.aws.workspacesweb.model.EnabledType] =
      scala
        .Option(impl.copyAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val downloadAllowed
        : Option[zio.aws.workspacesweb.model.EnabledType] = scala
      .Option(impl.downloadAllowed())
      .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val pasteAllowed: Option[zio.aws.workspacesweb.model.EnabledType] =
      scala
        .Option(impl.pasteAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val printAllowed: Option[zio.aws.workspacesweb.model.EnabledType] =
      scala
        .Option(impl.printAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val uploadAllowed
        : Option[zio.aws.workspacesweb.model.EnabledType] = scala
      .Option(impl.uploadAllowed())
      .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val userSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.userSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.UserSettings
  ): zio.aws.workspacesweb.model.UserSettings.ReadOnly = new Wrapper(impl)
}
