package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workspacesweb.model.primitives.{
  SubnetId,
  VpcId,
  SecurityGroupId,
  ClientToken,
  ARN
}
import scala.jdk.CollectionConverters._
final case class UpdateNetworkSettingsRequest(
    clientToken: Option[ClientToken] = None,
    networkSettingsArn: ARN,
    securityGroupIds: Option[Iterable[SecurityGroupId]] = None,
    subnetIds: Option[Iterable[SubnetId]] = None,
    vpcId: Option[VpcId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsRequest = {
    import UpdateNetworkSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .networkSettingsArn(ARN.unwrap(networkSettingsArn): java.lang.String)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.UpdateNetworkSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.UpdateNetworkSettingsRequest
      .wrap(buildAwsValue())
}
object UpdateNetworkSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.UpdateNetworkSettingsRequest =
      zio.aws.workspacesweb.model.UpdateNetworkSettingsRequest(
        clientToken.map(value => value),
        networkSettingsArn,
        securityGroupIds.map(value => value),
        subnetIds.map(value => value),
        vpcId.map(value => value)
      )
    def clientToken: Option[ClientToken]
    def networkSettingsArn: ARN
    def securityGroupIds: Option[List[SecurityGroupId]]
    def subnetIds: Option[List[SubnetId]]
    def vpcId: Option[VpcId]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getNetworkSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(networkSettingsArn)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsRequest
  ) extends zio.aws.workspacesweb.model.UpdateNetworkSettingsRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.workspacesweb.model.primitives.ClientToken(value))
    override val networkSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.networkSettingsArn())
    override val securityGroupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspacesweb.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val subnetIds: Option[List[SubnetId]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspacesweb.model.primitives.SubnetId(item)
        }.toList
      )
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.workspacesweb.model.primitives.VpcId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsRequest
  ): zio.aws.workspacesweb.model.UpdateNetworkSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
